/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.plugins;

import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.lang.reflect.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.JacksonXmlPresentInClassPathCondition;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Conditional(value={JacksonXmlPresentInClassPathCondition.class})
public class JacksonXmlModelPlugin
implements ModelBuilderPlugin {
    private final TypeResolver typeResolver;

    @Autowired
    public JacksonXmlModelPlugin(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void apply(ModelContext context) {
        JacksonXmlRootElement root = (JacksonXmlRootElement)AnnotationUtils.findAnnotation(this.forClass(context), JacksonXmlRootElement.class);
        if (root != null) {
            context.getBuilder().xml(this.buildXml(root));
        }
    }

    private Xml buildXml(JacksonXmlRootElement annotation) {
        return new Xml().name(this.defaultToNull(annotation.localName())).attribute(Boolean.valueOf(false)).namespace(this.defaultToNull(annotation.namespace())).wrapped(Boolean.valueOf(false));
    }

    private String defaultToNull(String value) {
        return "##default".equalsIgnoreCase(value) ? null : value;
    }

    private Class<?> forClass(ModelContext context) {
        return this.typeResolver.resolve((Type)context.getType(), new Type[0]).getErasedType();
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

