/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.annotation.JsonView;
import java.lang.reflect.Type;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

@Component
@Order
public class JacksonJsonViewProvider
implements ViewProviderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonJsonViewProvider.class);
    private final TypeResolver typeResolver;

    @Autowired
    public JacksonJsonViewProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public Optional<ResolvedType> viewFor(ResolvedType type, ResolvedMethodParameter parameter) {
        return this.viewFor(type, parameter.findAnnotation(JsonView.class));
    }

    public Optional<ResolvedType> viewFor(ResolvedType type, RequestMappingContext context) {
        return this.viewFor(type, context.findAnnotation(JsonView.class));
    }

    public Optional<ResolvedType> viewFor(ResolvedType type, OperationContext context) {
        return this.viewFor(type, context.findAnnotation(JsonView.class));
    }

    private Optional<ResolvedType> viewFor(ResolvedType type, Optional<JsonView> annotation) {
        Optional<ResolvedType> view = Optional.empty();
        if (annotation.isPresent()) {
            Class[] views = annotation.get().value();
            view = Optional.of(this.typeResolver.resolve((Type)views[0], new Type[0]));
            LOG.debug("Found view {} for type {}", (Object)ResolvedTypes.resolvedTypeSignature(view.get()).orElse("<null>"), (Object)ResolvedTypes.resolvedTypeSignature(type).orElse("<null>"));
        }
        return view;
    }
}

