/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import io.grpc.Attributes;
import io.grpc.Context;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;

final class GrpcServerConstants {
    static final Attributes.Key<String> ATTR_TRANS_KEY_CONN_ID = Attributes.Key.create((String)"conn_id");
    static final Attributes.Key<String> ATTR_TRANS_KEY_REMOTE_IP = Attributes.Key.create((String)"remote_ip");
    static final Attributes.Key<Integer> ATTR_TRANS_KEY_REMOTE_PORT = Attributes.Key.create((String)"remote_port");
    static final Attributes.Key<Integer> ATTR_TRANS_KEY_LOCAL_PORT = Attributes.Key.create((String)"local_port");
    static final Context.Key<String> CONTEXT_KEY_CONN_ID = Context.key((String)"conn_id");
    static final Context.Key<String> CONTEXT_KEY_CONN_REMOTE_IP = Context.key((String)"remote_ip");
    static final Context.Key<Integer> CONTEXT_KEY_CONN_REMOTE_PORT = Context.key((String)"remote_port");
    static final Context.Key<Integer> CONTEXT_KEY_CONN_LOCAL_PORT = Context.key((String)"local_port");
    static final Context.Key<Channel> CONTEXT_KEY_CHANNEL = Context.key((String)"ctx_channel");
    static final String REQUEST_BI_STREAM_SERVICE_NAME = "BiRequestStream";
    static final String REQUEST_BI_STREAM_METHOD_NAME = "requestBiStream";
    static final String REQUEST_SERVICE_NAME = "Request";
    static final String REQUEST_METHOD_NAME = "request";

    GrpcServerConstants() {
    }

    static class GrpcConfig {
        private static final String NACOS_REMOTE_SERVER_GRPC_PREFIX = "nacos.remote.server.grpc.";
        private static final String NACOS_REMOTE_SERVER_GRPC_SDK_PREFIX = "nacos.remote.server.grpc.sdk.";
        private static final String NACOS_REMOTE_SERVER_GRPC_CLUSTER_PREFIX = "nacos.remote.server.grpc.cluster.";
        @Deprecated
        static final String MAX_INBOUND_MSG_SIZE_PROPERTY = "nacos.remote.server.grpc.maxinbound.message.size";
        static final String SDK_MAX_INBOUND_MSG_SIZE_PROPERTY = "nacos.remote.server.grpc.sdk.max-inbound-message-size";
        static final String SDK_KEEP_ALIVE_TIME_PROPERTY = "nacos.remote.server.grpc.sdk.keep-alive-time";
        static final String SDK_KEEP_ALIVE_TIMEOUT_PROPERTY = "nacos.remote.server.grpc.sdk.keep-alive-timeout";
        static final String SDK_PERMIT_KEEP_ALIVE_TIME = "nacos.remote.server.grpc.sdk.permit-keep-alive-time";
        static final String CLUSTER_MAX_INBOUND_MSG_SIZE_PROPERTY = "nacos.remote.server.grpc.cluster.max-inbound-message-size";
        static final String CLUSTER_KEEP_ALIVE_TIME_PROPERTY = "nacos.remote.server.grpc.cluster.keep-alive-time";
        static final String CLUSTER_KEEP_ALIVE_TIMEOUT_PROPERTY = "nacos.remote.server.grpc.cluster.keep-alive-timeout";
        static final String CLUSTER_PERMIT_KEEP_ALIVE_TIME = "nacos.remote.server.grpc.cluster.permit-keep-alive-time";
        static final int DEFAULT_GRPC_MAX_INBOUND_MSG_SIZE = 0xA00000;
        static final long DEFAULT_GRPC_KEEP_ALIVE_TIME = TimeUnit.NANOSECONDS.toMillis(GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIME_NANOS);
        static final long DEFAULT_GRPC_KEEP_ALIVE_TIMEOUT = TimeUnit.NANOSECONDS.toMillis(GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS);
        static final long DEFAULT_GRPC_PERMIT_KEEP_ALIVE_TIME = TimeUnit.MINUTES.toMillis(5L);

        GrpcConfig() {
        }
    }
}

