/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.connection.ConnectionControlManager;
import com.alibaba.nacos.plugin.control.connection.nacos.NacosConnectionControlManager;
import com.alibaba.nacos.plugin.control.event.ConnectionLimitRuleChangeEvent;
import com.alibaba.nacos.plugin.control.event.TpsControlRuleChangeEvent;
import com.alibaba.nacos.plugin.control.ruleactivator.RuleParser;
import com.alibaba.nacos.plugin.control.ruleactivator.RuleParserProxy;
import com.alibaba.nacos.plugin.control.ruleactivator.RuleStorageProxy;
import com.alibaba.nacos.plugin.control.tps.TpsControlManager;
import com.alibaba.nacos.plugin.control.tps.nacos.NacosTpsControlManager;
import java.util.Collection;

public class ControlManagerCenter {
    static ControlManagerCenter instance = null;
    private TpsControlManager tpsControlManager;
    private ConnectionControlManager connectionControlManager;
    private RuleStorageProxy ruleStorageProxy;

    private void initConnectionManager() {
        Collection connectionControlManagers = NacosServiceLoader.load(ConnectionControlManager.class);
        String connectionManagerName = ControlConfigs.getInstance().getConnectionManager();
        for (ConnectionControlManager connectionControlManagerInternal : connectionControlManagers) {
            if (!connectionControlManagerInternal.getName().equalsIgnoreCase(connectionManagerName)) continue;
            Loggers.CONTROL.info("Found  connection control manager of name={},class={}", (Object)connectionManagerName, (Object)connectionControlManagerInternal.getClass().getSimpleName());
            this.connectionControlManager = connectionControlManagerInternal;
            break;
        }
        if (this.connectionControlManager == null) {
            Loggers.CONTROL.warn("Fail to connection control manager of name \uff1a" + connectionManagerName);
            this.connectionControlManager = new NacosConnectionControlManager();
        }
    }

    private void initTpsControlManager() {
        Collection tpsControlManagers = NacosServiceLoader.load(TpsControlManager.class);
        String tpsManagerName = ControlConfigs.getInstance().getTpsManager();
        for (TpsControlManager tpsControlManagerInternal : tpsControlManagers) {
            if (!tpsControlManagerInternal.getName().equalsIgnoreCase(tpsManagerName)) continue;
            Loggers.CONTROL.info("Found  tps control manager of name={},class={}", (Object)tpsManagerName, (Object)tpsControlManagerInternal.getClass().getSimpleName());
            this.tpsControlManager = tpsControlManagerInternal;
            break;
        }
        if (this.tpsControlManager == null) {
            Loggers.CONTROL.warn("Fail to found tps control manager of name \uff1a" + tpsManagerName);
            this.tpsControlManager = new NacosTpsControlManager();
        }
    }

    private ControlManagerCenter() {
        this.initTpsControlManager();
        this.initConnectionManager();
        this.ruleStorageProxy = new RuleStorageProxy();
    }

    public RuleStorageProxy getRuleStorageProxy() {
        return this.ruleStorageProxy;
    }

    public RuleParser getRuleParser() {
        return RuleParserProxy.getInstance();
    }

    public TpsControlManager getTpsControlManager() {
        return this.tpsControlManager;
    }

    public ConnectionControlManager getConnectionControlManager() {
        return this.connectionControlManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ControlManagerCenter getInstance() {
        if (instance != null) return instance;
        Class<ControlManagerCenter> clazz = ControlManagerCenter.class;
        synchronized (ControlManagerCenter.class) {
            if (instance != null) return instance;
            instance = new ControlManagerCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void reloadTpsControlRule(String pointName, boolean external) {
        NotifyCenter.publishEvent((Event)new TpsControlRuleChangeEvent(pointName, external));
    }

    public void reloadConnectionControlRule(boolean external) {
        NotifyCenter.publishEvent((Event)new ConnectionLimitRuleChangeEvent(external));
    }
}

