/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.merge;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.service.merge.MergeDataTask;
import com.alibaba.nacos.config.server.service.merge.MergeDatumService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoAggrPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.ContentUtils;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTaskProcessor
implements NacosTaskProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeTaskProcessor.class);
    private static final int PAGE_SIZE = 10000;
    private ConfigInfoPersistService configInfoPersistService;
    private ConfigInfoAggrPersistService configInfoAggrPersistService;
    private ConfigInfoTagPersistService configInfoTagPersistService;
    private MergeDatumService mergeService;

    MergeTaskProcessor(ConfigInfoPersistService configInfoPersistService, ConfigInfoAggrPersistService configInfoAggrPersistService, ConfigInfoTagPersistService configInfoTagPersistService, MergeDatumService mergeService) {
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoAggrPersistService = configInfoAggrPersistService;
        this.configInfoTagPersistService = configInfoTagPersistService;
        this.mergeService = mergeService;
    }

    public boolean process(NacosTask task) {
        MergeDataTask mergeTask = (MergeDataTask)task;
        String dataId = mergeTask.dataId;
        String group = mergeTask.groupId;
        String tenant = mergeTask.tenant;
        String tag = mergeTask.tag;
        String clientIp = mergeTask.getClientIp();
        try {
            ArrayList<ConfigInfoAggr> datumList = new ArrayList<ConfigInfoAggr>();
            int rowCount = this.configInfoAggrPersistService.aggrConfigInfoCount(dataId, group, tenant);
            int pageCount = (int)Math.ceil((double)rowCount * 1.0 / 10000.0);
            for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
                Page<ConfigInfoAggr> page = this.configInfoAggrPersistService.findConfigInfoAggrByPage(dataId, group, tenant, pageNo, 10000);
                if (page == null) continue;
                datumList.addAll(page.getPageItems());
                LOGGER.info("[merge-query] {}, {}, size/total={}/{}", new Object[]{dataId, group, datumList.size(), rowCount});
            }
            Timestamp time = TimeUtils.getCurrentTime();
            if (datumList.size() > 0) {
                ConfigInfo cf = MergeTaskProcessor.merge(dataId, group, tenant, datumList);
                this.configInfoPersistService.insertOrUpdate(null, null, cf, time, null);
                LOGGER.info("[merge-ok] {}, {}, size={}, length={}, md5={}, content={}", new Object[]{dataId, group, datumList.size(), cf.getContent().length(), cf.getMd5(), ContentUtils.truncateContent(cf.getContent())});
                ConfigTraceService.logPersistenceEvent(dataId, group, tenant, null, time.getTime(), InetUtils.getSelfIP(), "merge", cf.getContent());
            } else {
                if (StringUtils.isBlank((CharSequence)tag)) {
                    this.configInfoPersistService.removeConfigInfo(dataId, group, tenant, clientIp, null);
                } else {
                    this.configInfoTagPersistService.removeConfigInfoTag(dataId, group, tenant, tag, clientIp, null);
                }
                LOGGER.warn("[merge-delete] delete config info because no datum. dataId=" + dataId + ", groupId=" + group);
                ConfigTraceService.logPersistenceEvent(dataId, group, tenant, null, time.getTime(), InetUtils.getSelfIP(), "remove", null);
            }
            NotifyCenter.publishEvent((Event)new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
        }
        catch (Exception e) {
            this.mergeService.addMergeTask(dataId, group, tenant, mergeTask.getClientIp());
            LOGGER.info("[merge-error] " + dataId + ", " + group + ", " + e.toString(), (Throwable)e);
        }
        return true;
    }

    public static ConfigInfo merge(String dataId, String group, String tenant, List<ConfigInfoAggr> datumList) {
        StringBuilder sb = new StringBuilder();
        String appName = null;
        for (ConfigInfoAggr aggrInfo : datumList) {
            if (aggrInfo.getAppName() != null) {
                appName = aggrInfo.getAppName();
            }
            sb.append(aggrInfo.getContent());
            sb.append("\r\n");
        }
        String content = sb.substring(0, sb.lastIndexOf("\r\n"));
        return new ConfigInfo(dataId, group, tenant, appName, content);
    }
}

