/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.datasource;

import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public class DataSourcePoolProperties {
    public static final long DEFAULT_CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    public static final long DEFAULT_VALIDATION_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    public static final long DEFAULT_IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    public static final int DEFAULT_MAX_POOL_SIZE = 20;
    public static final int DEFAULT_MINIMUM_IDLE = 2;
    private final HikariDataSource dataSource = new HikariDataSource();

    private DataSourcePoolProperties() {
        this.dataSource.setIdleTimeout(DEFAULT_IDLE_TIMEOUT);
        this.dataSource.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
        this.dataSource.setValidationTimeout(DEFAULT_VALIDATION_TIMEOUT);
        this.dataSource.setMaximumPoolSize(20);
        this.dataSource.setMinimumIdle(2);
    }

    public static DataSourcePoolProperties build(Environment environment) {
        DataSourcePoolProperties result = new DataSourcePoolProperties();
        Binder.get((Environment)environment).bind("db.pool.config", Bindable.ofInstance((Object)result.getDataSource()));
        return result;
    }

    public void setDriverClassName(String driverClassName) {
        this.dataSource.setDriverClassName(driverClassName);
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.dataSource.setJdbcUrl(jdbcUrl);
    }

    public void setUsername(String username) {
        this.dataSource.setUsername(username);
    }

    public void setPassword(String password) {
        this.dataSource.setPassword(password);
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }
}

