/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.remote.request;

import com.alibaba.nacos.api.remote.Payload;
import java.util.Map;
import java.util.TreeMap;

public abstract class Request
implements Payload {
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private String requestId;

    public void putHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void putAllHeader(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        this.headers.putAll(headers);
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public String getHeader(String key, String defaultValue) {
        String value = this.headers.get(key);
        return value == null ? defaultValue : value;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public abstract String getModule();

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{headers=" + this.headers + ", requestId='" + this.requestId + '\'' + '}';
    }
}

