/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicReference;

public abstract class UniOperatorProcessor<I, O>
implements UniSubscriber<I>,
UniSubscription {
    protected final UniSubscriber<? super O> downstream;
    protected final AtomicReference<UniSubscription> upstream = new AtomicReference();

    public UniOperatorProcessor(UniSubscriber<? super O> downstream) {
        this.downstream = ParameterValidation.nonNull(downstream, "downstream");
    }

    @Override
    public void onSubscribe(UniSubscription subscription) {
        if (this.upstream.compareAndSet(null, subscription)) {
            this.downstream.onSubscribe(this);
        } else {
            subscription.cancel();
        }
    }

    @Override
    public void onItem(I item) {
        UniSubscription subscription = this.upstream.getAndSet(EmptyUniSubscription.CANCELLED);
        if (subscription != EmptyUniSubscription.CANCELLED) {
            this.downstream.onItem(item);
        }
    }

    @Override
    public void onFailure(Throwable failure) {
        UniSubscription subscription = this.upstream.getAndSet(EmptyUniSubscription.CANCELLED);
        if (subscription != EmptyUniSubscription.CANCELLED) {
            this.downstream.onFailure(failure);
        } else {
            Infrastructure.handleDroppedException(failure);
        }
    }

    @Override
    public void cancel() {
        UniSubscription subscription = this.upstream.getAndSet(EmptyUniSubscription.CANCELLED);
        if (subscription != null && subscription != EmptyUniSubscription.CANCELLED && subscription != EmptyUniSubscription.DONE) {
            subscription.cancel();
        }
    }

    public boolean isCancelled() {
        return this.upstream.get() == EmptyUniSubscription.CANCELLED;
    }
}

