/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure;

import io.seata.rm.tcc.config.TCCFenceConfig;
import io.seata.spring.boot.autoconfigure.SeataCoreAutoConfiguration;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;

@ConditionalOnExpression(value="${seata.enabled:true}")
@ConditionalOnBean(type={"javax.sql.DataSource", "org.springframework.transaction.PlatformTransactionManager"})
@ConditionalOnMissingBean(value={TCCFenceConfig.class})
@AutoConfigureAfter(value={SeataCoreAutoConfiguration.class, DataSourceAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class})
public class SeataTCCFenceAutoConfiguration {
    public static final String TCC_FENCE_DATA_SOURCE_BEAN_NAME = "seataTCCFenceDataSource";
    public static final String TCC_FENCE_TRANSACTION_MANAGER_BEAN_NAME = "seataTCCFenceTransactionManager";

    @Bean
    @ConfigurationProperties(value="seata.tcc.fence")
    public TCCFenceConfig tccFenceConfig(DataSource dataSource, PlatformTransactionManager transactionManager, @Qualifier(value="seataTCCFenceDataSource") @Autowired(required=false) DataSource tccFenceDataSource, @Qualifier(value="seataTCCFenceTransactionManager") @Autowired(required=false) PlatformTransactionManager tccFenceTransactionManager) {
        return new TCCFenceConfig(tccFenceDataSource != null ? tccFenceDataSource : dataSource, tccFenceTransactionManager != null ? tccFenceTransactionManager : transactionManager);
    }
}

