/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.xa;

import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.Resource;
import io.seata.rm.datasource.AbstractDataSourceCacheResourceManager;
import io.seata.rm.datasource.xa.AbstractDataSourceProxyXA;
import io.seata.rm.datasource.xa.ConnectionProxyXA;
import io.seata.rm.datasource.xa.XAXid;
import io.seata.rm.datasource.xa.XAXidBuilder;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerXA
extends AbstractDataSourceCacheResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManagerXA.class);

    @Override
    public void init() {
        LOGGER.info("ResourceManagerXA init ...");
    }

    public BranchType getBranchType() {
        return BranchType.XA;
    }

    public BranchStatus branchCommit(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        return this.finishBranch(true, branchType, xid, branchId, resourceId, applicationData);
    }

    public BranchStatus branchRollback(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        return this.finishBranch(false, branchType, xid, branchId, resourceId, applicationData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BranchStatus finishBranch(boolean committed, BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        XAXid xaBranchXid = XAXidBuilder.build(xid, branchId);
        Resource resource = (Resource)this.dataSourceCache.get(resourceId);
        if (!(resource instanceof AbstractDataSourceProxyXA)) {
            LOGGER.error("Unknown Resource for XA resource " + resourceId + " " + resource);
            if (!committed) return BranchStatus.PhaseTwo_RollbackFailed_Unretryable;
            return BranchStatus.PhaseTwo_CommitFailed_Unretryable;
        }
        try (ConnectionProxyXA connectionProxyXA = ((AbstractDataSourceProxyXA)resource).getConnectionForXAFinish(xaBranchXid);){
            if (committed) {
                connectionProxyXA.xaCommit(xid, branchId, applicationData);
                LOGGER.info(xaBranchXid + " was committed.");
                BranchStatus branchStatus2 = BranchStatus.PhaseTwo_Committed;
                return branchStatus2;
            }
            connectionProxyXA.xaRollback(xid, branchId, applicationData);
            LOGGER.info(xaBranchXid + " was rollbacked");
            BranchStatus branchStatus = BranchStatus.PhaseTwo_Rollbacked;
            return branchStatus;
        }
        catch (SQLException | XAException sqle) {
            if (sqle instanceof XAException && ((XAException)sqle).errorCode == -4) {
                if (!committed) return BranchStatus.PhaseTwo_Rollbacked;
                return BranchStatus.PhaseTwo_Committed;
            }
            if (committed) {
                LOGGER.info(xaBranchXid + " commit failed since " + sqle.getMessage(), (Throwable)sqle);
                return BranchStatus.PhaseTwo_CommitFailed_Retryable;
            }
            LOGGER.info(xaBranchXid + " rollback failed since " + sqle.getMessage(), (Throwable)sqle);
            return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
        }
    }
}

