/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry;

import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface RegistryService<T> {
    public static final String PREFIX_SERVICE_MAPPING = "vgroupMapping.";
    public static final String PREFIX_SERVICE_ROOT = "service";
    public static final String CONFIG_SPLIT_CHAR = ".";
    public static final Set<String> SERVICE_GROUP_NAME = new HashSet<String>();

    public void register(InetSocketAddress var1) throws Exception;

    public void unregister(InetSocketAddress var1) throws Exception;

    public void subscribe(String var1, T var2) throws Exception;

    public void unsubscribe(String var1, T var2) throws Exception;

    public List<InetSocketAddress> lookup(String var1) throws Exception;

    public void close() throws Exception;

    default public String getServiceGroup(String key) {
        key = "service.vgroupMapping." + key;
        if (!SERVICE_GROUP_NAME.contains(key)) {
            ConfigurationCache.addConfigListener((String)key, (ConfigurationChangeListener[])new ConfigurationChangeListener[0]);
            SERVICE_GROUP_NAME.add(key);
        }
        return ConfigurationFactory.getInstance().getConfig(key);
    }
}

