/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.seata.serializer.kryo.KryoSerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class KryoInnerSerializer
implements AutoCloseable {
    private final Kryo kryo;

    public KryoInnerSerializer(Kryo kryo) {
        this.kryo = Objects.requireNonNull(kryo);
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public <T> byte[] serialize(T t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        this.kryo.writeClassAndObject(output, t);
        output.close();
        return baos.toByteArray();
    }

    public <T> T deserialize(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        Input input = new Input((InputStream)bais);
        input.close();
        return (T)this.kryo.readClassAndObject(input);
    }

    @Override
    public void close() {
        KryoSerializerFactory.getInstance().returnKryo(this);
    }
}

