/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.tm;

import io.seata.common.util.StringUtils;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.GlobalStatus;
import io.seata.core.rpc.ShutdownHook;
import io.seata.core.rpc.netty.RmNettyRemotingClient;
import io.seata.core.rpc.netty.TmNettyRemotingClient;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.RMClient;
import io.seata.saga.rm.SagaResource;
import io.seata.saga.tm.SagaTransactionalTemplate;
import io.seata.tm.TMClient;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionContext;
import io.seata.tm.api.GlobalTransactionRole;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.transaction.TransactionHook;
import io.seata.tm.api.transaction.TransactionHookManager;
import io.seata.tm.api.transaction.TransactionInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class DefaultSagaTransactionalTemplate
implements SagaTransactionalTemplate,
ApplicationContextAware,
DisposableBean,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSagaTransactionalTemplate.class);
    private String applicationId;
    private String txServiceGroup;
    private String accessKey;
    private String secretKey;
    private ApplicationContext applicationContext;

    @Override
    public void commitTransaction(GlobalTransaction tx) throws TransactionalExecutor.ExecutionException {
        try {
            this.triggerBeforeCommit(tx);
            tx.commit();
            this.triggerAfterCommit(tx);
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.CommitFailure);
        }
    }

    @Override
    public void rollbackTransaction(GlobalTransaction tx, Throwable ex) throws TransactionException, TransactionalExecutor.ExecutionException {
        this.triggerBeforeRollback(tx);
        tx.rollback();
        this.triggerAfterRollback(tx);
    }

    @Override
    public GlobalTransaction beginTransaction(TransactionInfo txInfo) throws TransactionalExecutor.ExecutionException {
        GlobalTransaction tx = GlobalTransactionContext.getCurrentOrCreate();
        try {
            this.triggerBeforeBegin(tx);
            tx.begin(txInfo.getTimeOut(), txInfo.getName());
            this.triggerAfterBegin(tx);
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.BeginFailure);
        }
        return tx;
    }

    @Override
    public GlobalTransaction reloadTransaction(String xid) throws TransactionalExecutor.ExecutionException, TransactionException {
        return GlobalTransactionContext.reload(xid);
    }

    @Override
    public void reportTransaction(GlobalTransaction tx, GlobalStatus globalStatus) throws TransactionalExecutor.ExecutionException {
        try {
            tx.globalReport(globalStatus);
            this.triggerAfterCompletion(tx);
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.ReportFailure);
        }
    }

    @Override
    public long branchRegister(String resourceId, String clientId, String xid, String applicationData, String lockKeys) throws TransactionException {
        return DefaultResourceManager.get().branchRegister(BranchType.SAGA, resourceId, clientId, xid, applicationData, lockKeys);
    }

    @Override
    public void branchReport(String xid, long branchId, BranchStatus status, String applicationData) throws TransactionException {
        DefaultResourceManager.get().branchReport(BranchType.SAGA, xid, branchId, status, applicationData);
    }

    protected void triggerBeforeBegin(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.beforeBegin();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute beforeBegin in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerAfterBegin(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.afterBegin();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute afterBegin in hook {} ", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerBeforeRollback(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.beforeRollback();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute beforeRollback in hook {} ", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerAfterRollback(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.afterRollback();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute afterRollback in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerBeforeCommit(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.beforeCommit();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute beforeCommit in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerAfterCommit(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.afterCommit();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute afterCommit in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    @Override
    public void triggerAfterCompletion(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.afterCompletion();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute afterCompletion in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.initSeataClient();
    }

    public void destroy() {
        ShutdownHook.getInstance().destroyAll();
    }

    private void initSeataClient() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing Global Transaction Clients ... ");
        }
        if (StringUtils.isNullOrEmpty(this.applicationId) || StringUtils.isNullOrEmpty(this.txServiceGroup)) {
            throw new IllegalArgumentException("applicationId: " + this.applicationId + ", txServiceGroup: " + this.txServiceGroup);
        }
        TMClient.init(this.applicationId, this.txServiceGroup, this.accessKey, this.secretKey);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transaction Manager Client is initialized. applicationId[" + this.applicationId + "] txServiceGroup[" + this.txServiceGroup + "]");
        }
        RMClient.init(this.applicationId, this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Resource Manager is initialized. applicationId[" + this.applicationId + "] txServiceGroup[" + this.txServiceGroup + "]");
        }
        SagaResource sagaResource = new SagaResource();
        sagaResource.setResourceGroupId(this.getTxServiceGroup());
        sagaResource.setApplicationId(this.getApplicationId());
        DefaultResourceManager.get().registerResource(sagaResource);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Global Transaction Clients are initialized. ");
        }
        this.registerSpringShutdownHook();
    }

    private void registerSpringShutdownHook() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).registerShutdownHook();
            ShutdownHook.removeRuntimeShutdownHook();
        }
        ShutdownHook.getInstance().addDisposable(TmNettyRemotingClient.getInstance(this.applicationId, this.txServiceGroup, this.accessKey, this.secretKey));
        ShutdownHook.getInstance().addDisposable(RmNettyRemotingClient.getInstance(this.applicationId, this.txServiceGroup));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void cleanUp() {
        TransactionHookManager.clear();
    }

    protected List<TransactionHook> getCurrentHooks() {
        return TransactionHookManager.getHooks();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTxServiceGroup() {
        return this.txServiceGroup;
    }

    public void setTxServiceGroup(String txServiceGroup) {
        this.txServiceGroup = txServiceGroup;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}

