/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.util;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class OffsetTimeUtils {
    public static final String PATTERN_FORMAT_TIME = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final byte REGIONIDBIT = -128;
    private static final Map<Integer, String> ZONE_ID_MAP = new HashMap<Integer, String>(36);

    public static String getRegion(int code) {
        return ZONE_ID_MAP.get(code);
    }

    public static String convertOffSetTime(OffsetDateTime offsetDateTime) {
        if (null != offsetDateTime) {
            return offsetDateTime.format(DateTimeFormatter.ofPattern(PATTERN_FORMAT_TIME));
        }
        return null;
    }

    public static OffsetDateTime timeToOffsetDateTime(byte[] bytes) {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        OffsetDateTime utc = OffsetTimeUtils.extractUtc(bytes);
        if (bytes.length >= 8) {
            if (OffsetTimeUtils.isFixedOffset(bytes)) {
                ZoneOffset offset = OffsetTimeUtils.extractOffset(bytes);
                return utc.withOffsetSameInstant(offset);
            }
            ZoneId zoneId = OffsetTimeUtils.extractZoneId(bytes);
            return utc.atZoneSameInstant(zoneId).toOffsetDateTime();
        }
        return utc.atZoneSameInstant(ZoneId.systemDefault()).toOffsetDateTime();
    }

    private static boolean isFixedOffset(byte[] bytes) {
        return (bytes[11] & 0xFFFFFF80) == 0;
    }

    private static OffsetDateTime extractUtc(byte[] bytes) {
        return OffsetDateTime.of(OffsetTimeUtils.extractLocalDateTime(bytes), ZoneOffset.UTC);
    }

    private static ZoneId extractZoneId(byte[] bytes) {
        int regionCode = (bytes[11] & 0x7F) << 6;
        String regionName = OffsetTimeUtils.getRegion(regionCode += (bytes[12] & 0xFC) >> 2);
        return ZoneId.of(regionName);
    }

    private static ZoneOffset extractOffset(byte[] bytes) {
        int hours = bytes[11] - 20;
        int minutes = bytes[12] - 60;
        if (hours == 0 && minutes == 0) {
            return ZoneOffset.UTC;
        }
        return ZoneOffset.ofHoursMinutes(hours, minutes);
    }

    private static LocalDateTime extractLocalDateTime(byte[] bytes) {
        int year = (Short.toUnsignedInt(bytes[0]) - 100) * 100 + (Short.toUnsignedInt(bytes[1]) - 100);
        byte month = bytes[2];
        byte dayOfMonth = bytes[3];
        int hour = bytes[4] - 1;
        int minute = bytes[5] - 1;
        int second = bytes[6] - 1;
        int nanoOfSecond = 0;
        if (bytes.length >= 8) {
            nanoOfSecond = Short.toUnsignedInt(bytes[7]) << 24 | Short.toUnsignedInt(bytes[8]) << 16 | Short.toUnsignedInt(bytes[9]) << 8 | Short.toUnsignedInt(bytes[10]);
        }
        return LocalDateTime.of(year, month, (int)dayOfMonth, hour, minute, second, nanoOfSecond);
    }

    static {
        ZONE_ID_MAP.put(250, "Asia/Shanghai");
        ZONE_ID_MAP.put(345, "Australia/Darwin");
        ZONE_ID_MAP.put(352, "Australia/Sydney");
        ZONE_ID_MAP.put(687, "America/Argentina/Buenos_Aires");
        ZONE_ID_MAP.put(106, "America/Anchorage");
        ZONE_ID_MAP.put(188, "America/Sao_Paulo");
        ZONE_ID_MAP.put(756, "Asia/Dhaka");
        ZONE_ID_MAP.put(80, "Africa/Harare");
        ZONE_ID_MAP.put(118, "America/St_Johns");
        ZONE_ID_MAP.put(101, "America/Chicago");
        ZONE_ID_MAP.put(47, "Africa/Addis_Ababa");
        ZONE_ID_MAP.put(382, "Europe/Paris");
        ZONE_ID_MAP.put(1647, "America/Indiana/Indianapolis");
        ZONE_ID_MAP.put(772, "Asia/Kolkata");
        ZONE_ID_MAP.put(267, "Asia/Tokyo");
        ZONE_ID_MAP.put(479, "Pacific/Apia");
        ZONE_ID_MAP.put(241, "Asia/Yerevan");
        ZONE_ID_MAP.put(471, "Pacific/Auckland");
        ZONE_ID_MAP.put(284, "Asia/Karachi");
        ZONE_ID_MAP.put(109, "America/Phoenix");
        ZONE_ID_MAP.put(167, "America/Puerto_Rico");
        ZONE_ID_MAP.put(103, "America/Los_Angeles");
        ZONE_ID_MAP.put(481, "Pacific/Guadalcanal");
        ZONE_ID_MAP.put(813, "Asia/Ho_Chi_Minh");
        ZONE_ID_MAP.put(1474, "HST");
        ZONE_ID_MAP.put(1636, "EST");
        ZONE_ID_MAP.put(2662, "MST");
    }
}

