/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.sqlserver;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.SqlGenerateUtils;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.SQLUndoLog;
import io.seata.rm.datasource.undo.sqlserver.BaseSqlServerUndoExecutor;
import io.seata.sqlparser.util.ColumnUtils;
import java.util.List;
import java.util.stream.Collectors;

public class SqlServerUndoUpdateExecutor
extends BaseSqlServerUndoExecutor {
    public SqlServerUndoUpdateExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected String buildUndoSQL() {
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (CollectionUtils.isEmpty(beforeImageRows)) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        List<Field> nonPkFields = row.nonPrimaryKeys();
        String updateColumns = nonPkFields.stream().map(field -> ColumnUtils.addEscape(field.getName(), "sqlserver") + " = ?").collect(Collectors.joining(", "));
        List<String> pkNameList = this.getOrderedPkList(beforeImage, row, "sqlserver").stream().map(Field::getName).collect(Collectors.toList());
        String whereSql = SqlGenerateUtils.buildWhereConditionByPKs(pkNameList, "sqlserver");
        return "UPDATE " + this.sqlUndoLog.getTableName() + " SET " + updateColumns + " WHERE " + whereSql;
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

