/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser;

import io.seata.common.util.StringUtils;
import io.seata.sqlparser.struct.TableMeta;

public interface EscapeHandler {
    public static final String DOT = ".";

    public boolean checkIfKeyWords(String var1);

    public boolean checkIfNeedEscape(String var1, TableMeta var2);

    default public char getEscapeSymbol() {
        return '\"';
    }

    default public boolean containsEscape(String fieldOrTableName) {
        fieldOrTableName = fieldOrTableName.trim();
        char escapeSymbol = this.getEscapeSymbol();
        return fieldOrTableName.charAt(0) == escapeSymbol && fieldOrTableName.charAt(fieldOrTableName.length() - 1) == escapeSymbol;
    }

    default public String addColNameEscape(String colName) {
        return this.addColNameEscape(colName, null);
    }

    default public String addColNameEscape(String colName, TableMeta tableMeta) {
        boolean needEscape;
        String colNameToCheck = colName;
        if (colName.contains(DOT)) {
            colNameToCheck = colName.substring(colName.lastIndexOf(DOT) + 1);
        }
        if (!(needEscape = this.checkIfNeedEscape(colNameToCheck, tableMeta))) {
            return colName;
        }
        char escapeChar = this.getEscapeSymbol();
        if (colName.contains(DOT)) {
            String str = escapeChar + DOT;
            int dotIndex = colName.indexOf(str);
            if (dotIndex > -1) {
                return new StringBuilder().append(colName, 0, dotIndex + str.length()).append(escapeChar).append(colName.substring(dotIndex + str.length())).append(escapeChar).toString();
            }
            str = DOT + escapeChar;
            dotIndex = colName.indexOf(str);
            if (dotIndex > -1) {
                return new StringBuilder().append(escapeChar).append(colName, 0, dotIndex).append(escapeChar).append(colName.substring(dotIndex)).toString();
            }
            str = DOT;
            dotIndex = colName.indexOf(str);
            if (dotIndex > -1) {
                return new StringBuilder().append(escapeChar).append(colName, 0, dotIndex).append(escapeChar).append(DOT).append(escapeChar).append(colName.substring(dotIndex + str.length())).append(escapeChar).toString();
            }
        }
        char[] buf = new char[colName.length() + 2];
        buf[0] = escapeChar;
        buf[buf.length - 1] = escapeChar;
        colName.getChars(0, colName.length(), buf, 1);
        return new String(buf).intern();
    }

    default public String delColNameEscape(String colName) {
        if (StringUtils.isBlank(colName)) {
            return colName;
        }
        char escapeChar = this.getEscapeSymbol();
        if (colName.charAt(0) == escapeChar && colName.charAt(colName.length() - 1) == escapeChar) {
            String str = escapeChar + DOT + escapeChar;
            int index = colName.indexOf(str);
            if (index > -1) {
                return colName.substring(1, index) + DOT + colName.substring(index + str.length(), colName.length() - 1);
            }
            return colName.substring(1, colName.length() - 1);
        }
        String str = escapeChar + DOT;
        int index = colName.indexOf(str);
        if (index > -1 && colName.charAt(0) == escapeChar) {
            return colName.substring(1, index) + DOT + colName.substring(index + str.length());
        }
        str = DOT + escapeChar;
        index = colName.indexOf(str);
        if (index > -1 && colName.charAt(colName.length() - 1) == escapeChar) {
            return colName.substring(0, index) + DOT + colName.substring(index + str.length(), colName.length() - 1);
        }
        return colName;
    }
}

