/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.aot;

import io.seata.common.aot.NativeUtils;
import io.seata.common.util.ReflectionUtil;
import io.seata.spring.aot.ResourceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.core.SpringProperties;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class AotUtils
extends NativeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AotUtils.class);
    public static final String SPRING_AOT_ENABLED = "spring.aot.enabled";
    public static final MemberCategory[] ALL_MEMBER_CATEGORIES = MemberCategory.values();
    public static final MemberCategory[] EMPTY_MEMBER_CATEGORIES = new MemberCategory[0];
    public static final MemberCategory[] MEMBER_CATEGORIES_FOR_INSTANTIATE = new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS};
    public static final MemberCategory[] MEMBER_CATEGORIES_FOR_INSTANTIATE_AND_INVOKE = new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS};

    public static boolean isSpringAotEnabled() {
        return SpringProperties.getFlag((String)SPRING_AOT_ENABLED);
    }

    public static void registerType(ReflectionHints reflectionHints, Class<?> clazz, MemberCategory ... memberCategories) {
        reflectionHints.registerType(clazz, memberCategories);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Register reflection type '{}' with member categories {}", (Object)clazz.getName(), (Object)memberCategories);
        }
    }

    public static void registerType(ReflectionHints reflectionHints, String className, MemberCategory ... memberCategories) {
        try {
            Class<?> clazz = ReflectionUtil.getClassByName(className);
            AotUtils.registerType(reflectionHints, clazz, memberCategories);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Register reflection type failed: class not found '{}'.", (Object)className);
        }
        catch (NoClassDefFoundError e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Register reflection type '{}' error:", (Object)className, (Object)e);
            }
            LOGGER.warn("Register reflection type '{}' error: {}: {}", new Object[]{className, e.getClass().getName(), e.getMessage()});
        }
    }

    public static void registerTypes(ReflectionHints reflectionHints, MemberCategory[] memberCategories, String ... classNames) {
        for (String className : classNames) {
            try {
                AotUtils.registerType(reflectionHints, ReflectionUtil.getClassByName(className), memberCategories);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Register reflection type failed: class not found '{}'.", (Object)className);
            }
            catch (NoClassDefFoundError e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn("Register reflection type '{}' error:", (Object)className, (Object)e);
                    continue;
                }
                LOGGER.warn("Register reflection type '{}' error: {}: {}", new Object[]{className, e.getClass().getName(), e.getMessage()});
            }
        }
    }

    public static void registerTypes(ReflectionHints reflectionHints, MemberCategory[] memberCategories, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            AotUtils.registerType(reflectionHints, clazz, memberCategories);
        }
    }

    public static void registerTypesForSerialize(ReflectionHints reflectionHints, Class<?> ... classes) {
        AotUtils.registerTypes(reflectionHints, ALL_MEMBER_CATEGORIES, classes);
    }

    public static void registerTypesForSerialize(ReflectionHints reflectionHints, String ... classNames) {
        AotUtils.registerTypes(reflectionHints, ALL_MEMBER_CATEGORIES, classNames);
    }

    public static void registerServices(ReflectionHints reflectionHints, String location, @Nullable Predicate<Resource> predicate, MemberCategory ... memberCategories) {
        Resource[] resources;
        for (Resource resource : resources = ResourceUtil.getResources(location)) {
            if (predicate != null && !predicate.test(resource)) continue;
            try (InputStreamReader isr = new InputStreamReader(resource.getInputStream());
                 BufferedReader br = new BufferedReader(isr);){
                br.lines().forEach(className -> AotUtils.registerTypes(reflectionHints, memberCategories, className));
            }
            catch (IOException e) {
                LOGGER.error("Register services '{}' fail:", (Object)resource.getFilename(), (Object)e);
            }
        }
    }

    public static void registerServices(ReflectionHints reflectionHints, String location, MemberCategory ... memberCategories) {
        AotUtils.registerServices(reflectionHints, location, null, memberCategories);
    }

    public static void registerServices(ReflectionHints reflectionHints, @Nullable Predicate<Resource> predicate, MemberCategory ... memberCategories) {
        AotUtils.registerServices(reflectionHints, "classpath*:META-INF/services/*", predicate, memberCategories);
    }

    public static void registerServices(ReflectionHints reflectionHints, MemberCategory ... memberCategories) {
        AotUtils.registerServices(reflectionHints, "classpath*:META-INF/services/*", null, memberCategories);
    }

    public static void registerAllOfClass(boolean registerSelf, ReflectionHints reflectionHints, Class<?> clazz, MemberCategory ... memberCategories) {
        AotUtils.registerAllOfClassInternal(new HashSet(), registerSelf, reflectionHints, clazz, memberCategories);
    }

    private static void registerAllOfClassInternal(@NonNull Set<Class<?>> cache, boolean registerSelf, ReflectionHints reflectionHints, Class<?> clazz, MemberCategory ... memberCategories) {
        Method[] methodArray;
        Field[] fields;
        if (clazz == null) {
            return;
        }
        if (clazz.isPrimitive() || clazz.isEnum() || clazz.isAnnotation()) {
            return;
        }
        if (clazz.isArray()) {
            AotUtils.registerAllOfClassInternal(cache, true, reflectionHints, clazz.getComponentType(), memberCategories);
            return;
        }
        if (ReflectionUtil.isJavaClass(clazz)) {
            return;
        }
        if (cache.contains(clazz)) {
            return;
        }
        cache.add(clazz);
        if (registerSelf) {
            AotUtils.registerType(reflectionHints, clazz, memberCategories);
        }
        Set<Class<?>> interfaceClasses = ReflectionUtil.getInterfaces(clazz);
        for (Class<?> clazz2 : interfaceClasses) {
            if (clazz2.equals(clazz)) continue;
            AotUtils.registerAllOfClassInternal(cache, true, reflectionHints, clazz2, memberCategories);
        }
        AotUtils.registerAllOfClassInternal(cache, true, reflectionHints, clazz.getSuperclass(), memberCategories);
        for (Field field : fields = ReflectionUtil.getAllFields(clazz)) {
            AotUtils.registerAllOfClassInternal(cache, true, reflectionHints, field.getType(), memberCategories);
        }
        for (Method method : methodArray = clazz.getMethods()) {
            Class<?>[] parameterTypes;
            for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                AotUtils.registerAllOfClassInternal(cache, true, reflectionHints, parameterType, memberCategories);
            }
        }
    }
}

