/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.expression.spel;

import io.seata.saga.engine.expression.Expression;
import io.seata.saga.engine.expression.ExpressionFactory;
import io.seata.saga.engine.expression.spel.SpringELExpression;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpringELExpressionFactory
implements ExpressionFactory,
ApplicationContextAware {
    ExpressionParser parser = new SpelExpressionParser();
    ApplicationContext applicationContext;

    @Override
    public Expression createExpression(String expression) {
        org.springframework.expression.Expression defaultExpression = this.parser.parseExpression(expression);
        EvaluationContext evaluationContext = ((SpelExpression)defaultExpression).getEvaluationContext();
        ((StandardEvaluationContext)evaluationContext).setBeanResolver((BeanResolver)new AppContextBeanResolver());
        return new SpringELExpression(defaultExpression);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private class AppContextBeanResolver
    implements BeanResolver {
        private AppContextBeanResolver() {
        }

        public Object resolve(EvaluationContext context, String beanName) throws AccessException {
            return SpringELExpressionFactory.this.applicationContext.getBean(beanName);
        }
    }
}

