/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.evaluation.exception;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.evaluation.Evaluator;
import io.seata.saga.engine.exception.EngineExecutionException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExceptionMatchEvaluator
implements Evaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionMatchEvaluator.class);
    private String exceptionString;
    private Class<Exception> exceptionClass;
    private String rootObjectName = "currentException";

    @Override
    public boolean evaluate(Map<String, Object> variables) {
        Object eObj = variables.get(this.getRootObjectName());
        if (eObj instanceof Exception && StringUtils.hasText((String)this.exceptionString)) {
            Exception e = (Exception)eObj;
            String exceptionClassName = e.getClass().getName();
            if (exceptionClassName.equals(this.exceptionString)) {
                return true;
            }
            try {
                if (this.exceptionClass.isAssignableFrom(e.getClass())) {
                    return true;
                }
            }
            catch (Exception e1) {
                LOGGER.error("Exception Match failed. expression[{}]", (Object)this.exceptionString, (Object)e1);
            }
        }
        return false;
    }

    public String getExceptionString() {
        return this.exceptionString;
    }

    public void setExceptionString(String exceptionString) {
        this.exceptionString = exceptionString;
        try {
            this.exceptionClass = Class.forName(exceptionString);
        }
        catch (ClassNotFoundException e) {
            throw new EngineExecutionException(e, exceptionString + " is not a Exception Class", FrameworkErrorCode.NotExceptionClass);
        }
    }

    public Class<Exception> getExceptionClass() {
        return this.exceptionClass;
    }

    public void setExceptionClass(Class<Exception> exceptionClass) {
        this.exceptionClass = exceptionClass;
        this.exceptionString = exceptionClass.getName();
    }

    public String getRootObjectName() {
        return this.rootObjectName;
    }

    public void setRootObjectName(String rootObjectName) {
        this.rootObjectName = rootObjectName;
    }
}

