/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm.api;

import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.transaction.TransactionInfo;

public interface TransactionalExecutor {
    public Object execute() throws Throwable;

    public TransactionInfo getTransactionInfo();

    public static class ExecutionException
    extends Exception {
        private GlobalTransaction transaction;
        private Code code;
        private Throwable originalException;

        public ExecutionException(GlobalTransaction transaction, Throwable cause, Code code) {
            this(transaction, cause, code, null);
        }

        public ExecutionException(GlobalTransaction transaction, Code code, Throwable originalException) {
            this(transaction, null, code, originalException);
        }

        public ExecutionException(GlobalTransaction transaction, Throwable cause, Code code, Throwable originalException) {
            this(transaction, null, cause, code, originalException);
        }

        public ExecutionException(GlobalTransaction transaction, String message, Throwable cause, Code code, Throwable originalException) {
            super(message, cause);
            this.transaction = transaction;
            this.code = code;
            this.originalException = originalException;
        }

        public GlobalTransaction getTransaction() {
            return this.transaction;
        }

        public void setTransaction(GlobalTransaction transaction) {
            this.transaction = transaction;
        }

        public Code getCode() {
            return this.code;
        }

        public void setCode(Code code) {
            this.code = code;
        }

        public Throwable getOriginalException() {
            return this.originalException;
        }

        public void setOriginalException(Throwable originalException) {
            this.originalException = originalException;
        }
    }

    public static enum Code {
        Unknown,
        BeginFailure,
        CommitFailure,
        RollbackFailure,
        RollbackDone,
        ReportFailure,
        Rollbacking;

    }
}

