/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry;

import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public interface RegistryService<T> {
    public static final String PREFIX_SERVICE_MAPPING = "vgroupMapping.";
    public static final String PREFIX_SERVICE_ROOT = "service";
    public static final String CONFIG_SPLIT_CHAR = ".";
    public static final Set<String> SERVICE_GROUP_NAME = new HashSet<String>();
    public static final Map<String, List<InetSocketAddress>> CURRENT_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();

    public void register(InetSocketAddress var1) throws Exception;

    public void unregister(InetSocketAddress var1) throws Exception;

    public void subscribe(String var1, T var2) throws Exception;

    public void unsubscribe(String var1, T var2) throws Exception;

    public List<InetSocketAddress> lookup(String var1) throws Exception;

    public void close() throws Exception;

    default public String getServiceGroup(String key) {
        key = "service.vgroupMapping." + key;
        if (!SERVICE_GROUP_NAME.contains(key)) {
            ConfigurationCache.addConfigListener(key, new ConfigurationChangeListener[0]);
            SERVICE_GROUP_NAME.add(key);
        }
        return ConfigurationFactory.getInstance().getConfig(key);
    }

    default public List<InetSocketAddress> aliveLookup(String transactionServiceGroup) {
        return CURRENT_ADDRESS_MAP.computeIfAbsent(transactionServiceGroup, k -> new ArrayList());
    }

    default public List<InetSocketAddress> refreshAliveLookup(String transactionServiceGroup, List<InetSocketAddress> aliveAddress) {
        return CURRENT_ADDRESS_MAP.put(transactionServiceGroup, aliveAddress);
    }
}

