/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.thread.NamedThreadFactory;
import io.seata.config.ConfigurationChangeEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public interface ConfigurationChangeListener {
    public static final int CORE_LISTENER_THREAD = 1;
    public static final int MAX_LISTENER_THREAD = 1;
    public static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("configListenerOperate", 1));

    public void onChangeEvent(ConfigurationChangeEvent var1);

    default public void onProcessEvent(ConfigurationChangeEvent event) {
        this.getExecutorService().submit(() -> {
            this.beforeEvent();
            this.onChangeEvent(event);
            this.afterEvent();
        });
    }

    default public void onShutDown() {
        this.getExecutorService().shutdownNow();
    }

    default public ExecutorService getExecutorService() {
        return EXECUTOR_SERVICE;
    }

    default public void beforeEvent() {
    }

    default public void afterEvent() {
    }
}

