/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec.mysql;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.common.util.IOUtil;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.BaseInsertExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.struct.ColumnMeta;
import io.seata.sqlparser.struct.Defaultable;
import io.seata.sqlparser.struct.Null;
import io.seata.sqlparser.struct.SqlMethodExpr;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="mysql", scope=Scope.PROTOTYPE)
public class MySQLInsertExecutor
extends BaseInsertExecutor
implements Defaultable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLInsertExecutor.class);
    public static final String ERR_SQL_STATE = "S1009";
    public static final Map<String, BigDecimal> RESOURCE_ID_STEP_CACHE = new ConcurrentHashMap<String, BigDecimal>(8);

    public MySQLInsertExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    public Map<String, List<Object>> getPkValues() throws SQLException {
        Map<String, List<Object>> pkValuesMap = null;
        List<String> pkColumnNameList = this.getTableMeta().getPrimaryKeyOnlyName();
        boolean isContainsPk = this.containsPK();
        if (pkColumnNameList.size() == 1) {
            pkValuesMap = isContainsPk ? this.getPkValuesByColumn() : (this.containsColumns() ? this.getPkValuesByAuto() : this.getPkValuesByColumn());
        } else {
            pkValuesMap = this.getPkValuesByColumn();
            for (String columnName : pkColumnNameList) {
                ColumnMeta pkColumnMeta;
                if (pkValuesMap.containsKey(columnName) || !Objects.nonNull(pkColumnMeta = this.getTableMeta().getColumnMeta(columnName)) || !pkColumnMeta.isAutoincrement()) continue;
                pkValuesMap.putAll(this.getPkValuesByAuto());
            }
        }
        return pkValuesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Object>> getPkValuesByAuto() throws SQLException {
        HashMap<String, List<Object>> pkValuesMap = new HashMap<String, List<Object>>(8);
        Map<String, ColumnMeta> pkMetaMap = this.getTableMeta().getPrimaryKeyMap();
        String autoColumnName = null;
        for (Map.Entry<String, ColumnMeta> entry : pkMetaMap.entrySet()) {
            if (!entry.getValue().isAutoincrement()) continue;
            autoColumnName = entry.getKey();
            break;
        }
        if (StringUtils.isBlank(autoColumnName)) {
            throw new ShouldNeverHappenException("auto increment column not exist");
        }
        ResultSet genKeys = null;
        boolean isManualCloseResultSet = false;
        try {
            genKeys = this.statementProxy.getGeneratedKeys();
        }
        catch (SQLException e) {
            if (ERR_SQL_STATE.equalsIgnoreCase(e.getSQLState())) {
                LOGGER.error("Fail to get auto-generated keys, use 'SELECT LAST_INSERT_ID()' instead. Be cautious, statement could be polluted. Recommend you set the statement to return generated keys.");
                int updateCount = this.statementProxy.getUpdateCount();
                try {
                    genKeys = this.statementProxy.getTargetStatement().executeQuery("SELECT LAST_INSERT_ID()");
                    if (updateCount > 1 && this.canAutoIncrement(pkMetaMap)) {
                        genKeys.next();
                        BigDecimal firstId = new BigDecimal(genKeys.getString(1));
                        Map<String, List<Object>> map = this.autoGeneratePks(firstId, autoColumnName, updateCount);
                        return map;
                    }
                    isManualCloseResultSet = true;
                }
                finally {
                    if (!isManualCloseResultSet) {
                        IOUtil.close((AutoCloseable)genKeys);
                    }
                }
            }
            throw e;
        }
        ArrayList<Object> pkValues = new ArrayList<Object>();
        while (genKeys.next()) {
            Object v = genKeys.getObject(1);
            pkValues.add(v);
        }
        try {
            genKeys.beforeFirst();
        }
        catch (SQLException e) {
            LOGGER.warn("Fail to reset ResultSet cursor. can not get primary key value");
        }
        finally {
            if (isManualCloseResultSet) {
                IOUtil.close((AutoCloseable)genKeys);
            }
        }
        pkValuesMap.put(autoColumnName, pkValues);
        return pkValuesMap;
    }

    @Override
    public Map<String, List<Object>> getPkValuesByColumn() throws SQLException {
        Map<String, List<Object>> pkValuesMap = this.parsePkValuesFromStatement();
        HashSet<String> keySet = new HashSet<String>(pkValuesMap.keySet());
        for (String pkKey : keySet) {
            List<Object> pkValues = pkValuesMap.get(pkKey);
            if (pkValues.size() == 1 && pkValues.get(0) instanceof SqlMethodExpr) {
                pkValuesMap.putAll(this.getPkValuesByAuto());
                continue;
            }
            if (pkValues.isEmpty() || !(pkValues.get(0) instanceof Null)) continue;
            pkValuesMap.putAll(this.getPkValuesByAuto());
        }
        return pkValuesMap;
    }

    @Override
    @Deprecated
    public List<Object> getPkValuesByDefault() throws SQLException {
        throw new NotSupportYetException();
    }

    @Override
    public List<Object> getPkValuesByDefault(String pkKey) throws SQLException {
        throw new NotSupportYetException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, List<Object>> autoGeneratePks(BigDecimal cursor, String autoColumnName, Integer updateCount) throws SQLException {
        BigDecimal step = BigDecimal.ONE;
        String resourceId = this.statementProxy.getConnectionProxy().getDataSourceProxy().getResourceId();
        if (RESOURCE_ID_STEP_CACHE.containsKey(resourceId)) {
            step = RESOURCE_ID_STEP_CACHE.get(resourceId);
        } else {
            ResultSet increment = null;
            try {
                increment = this.statementProxy.getTargetStatement().executeQuery("SHOW VARIABLES LIKE 'auto_increment_increment'");
                increment.next();
                step = new BigDecimal(increment.getString(2));
                RESOURCE_ID_STEP_CACHE.put(resourceId, step);
            }
            catch (Throwable throwable) {
                IOUtil.close(increment);
                throw throwable;
            }
            IOUtil.close((AutoCloseable)increment);
        }
        ArrayList<BigDecimal> pkValues = new ArrayList<BigDecimal>();
        int i = 0;
        while (true) {
            if (i >= updateCount) {
                HashMap<String, List<Object>> pkValuesMap = new HashMap<String, List<Object>>(1, 1.001f);
                pkValuesMap.put(autoColumnName, pkValues);
                return pkValuesMap;
            }
            pkValues.add(cursor);
            cursor = cursor.add(step);
            ++i;
        }
    }

    protected boolean canAutoIncrement(Map<String, ColumnMeta> primaryKeyMap) {
        if (primaryKeyMap.size() != 1) {
            return false;
        }
        Iterator<ColumnMeta> iterator = primaryKeyMap.values().iterator();
        if (iterator.hasNext()) {
            ColumnMeta pk = iterator.next();
            return pk.isAutoincrement();
        }
        return false;
    }
}

