/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid;

import io.seata.sqlparser.druid.DefaultDruidLoader;
import io.seata.sqlparser.druid.DruidLoader;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;

class DruidIsolationClassLoader
extends URLClassLoader {
    private static final String[] DRUID_CLASS_PREFIX = new String[]{"com.alibaba.druid.", "io.seata.sqlparser.druid."};
    private static final DruidIsolationClassLoader INSTANCE = new DruidIsolationClassLoader(DefaultDruidLoader.get());

    DruidIsolationClassLoader(DruidLoader druidLoader) {
        super(DruidIsolationClassLoader.getDruidUrls(druidLoader), DruidIsolationClassLoader.class.getClassLoader());
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String prefix : DRUID_CLASS_PREFIX) {
            if (!name.startsWith(prefix)) continue;
            return this.loadInternalClass(name, resolve);
        }
        return super.loadClass(name, resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadInternalClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private static URL[] getDruidUrls(DruidLoader druidLoader) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(DruidIsolationClassLoader.findClassLocation(DruidIsolationClassLoader.class));
        urls.add(druidLoader.getEmbeddedDruidLocation());
        return urls.toArray(new URL[0]);
    }

    private static URL findClassLocation(Class<?> clazz) {
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        if (cs == null) {
            throw new IllegalStateException("Not a normal druid startup environment");
        }
        return cs.getLocation();
    }

    static DruidIsolationClassLoader get() {
        return INSTANCE;
    }
}

