/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.compressor;

public enum CompressorType {
    NONE(0),
    GZIP(1),
    ZIP(2),
    SEVENZ(3),
    BZIP2(4),
    LZ4(5),
    DEFLATER(6);

    private final byte code;

    private CompressorType(byte code) {
        this.code = code;
    }

    public static CompressorType getByCode(int code) {
        for (CompressorType b : CompressorType.values()) {
            if (code != b.code) continue;
            return b;
        }
        throw new IllegalArgumentException("unknown codec:" + code);
    }

    public static CompressorType getByName(String name) {
        for (CompressorType b : CompressorType.values()) {
            if (!b.name().equalsIgnoreCase(name)) continue;
            return b;
        }
        throw new IllegalArgumentException("unknown codec:" + name);
    }

    public byte getCode() {
        return this.code;
    }
}

