/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.strategy.impl;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.pcext.utils.CompensationHolder;
import io.seata.saga.engine.strategy.StatusDecisionStrategy;
import io.seata.saga.engine.utils.ExceptionUtils;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStatusDecisionStrategy
implements StatusDecisionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatusDecisionStrategy.class);

    public static void decideMachineCompensateStatus(StateMachineInstance stateMachineInstance, CompensationHolder compensationHolder) {
        if (stateMachineInstance.getStatus() == null || ExecutionStatus.RU.equals((Object)stateMachineInstance.getStatus())) {
            stateMachineInstance.setStatus(ExecutionStatus.UN);
        }
        if (!compensationHolder.getStateStackNeedCompensation().isEmpty()) {
            boolean hasCompensateSUorUN = false;
            for (StateInstance forCompensateState : compensationHolder.getStatesForCompensation().values()) {
                if (!ExecutionStatus.UN.equals((Object)forCompensateState.getStatus()) && !ExecutionStatus.SU.equals((Object)forCompensateState.getStatus())) continue;
                hasCompensateSUorUN = true;
                break;
            }
            if (hasCompensateSUorUN) {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.UN);
            } else {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.FA);
            }
        } else {
            boolean hasCompensateError = false;
            for (StateInstance forCompensateState : compensationHolder.getStatesForCompensation().values()) {
                if (ExecutionStatus.SU.equals((Object)forCompensateState.getStatus())) continue;
                hasCompensateError = true;
                break;
            }
            if (hasCompensateError) {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.UN);
            } else {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.SU);
            }
        }
    }

    public static boolean setMachineStatusBasedOnStateList(StateMachineInstance stateMachineInstance, List<StateInstance> stateList) {
        boolean hasSetStatus = false;
        if (stateList != null && stateList.size() > 0) {
            boolean hasSuccessUpdateService = false;
            boolean hasUnsuccessService = false;
            for (int i = stateList.size() - 1; i >= 0; --i) {
                StateInstance stateInstance = stateList.get(i);
                if (stateInstance.isIgnoreStatus() || stateInstance.isForCompensation()) continue;
                if (ExecutionStatus.UN.equals((Object)stateInstance.getStatus())) {
                    stateMachineInstance.setStatus(ExecutionStatus.UN);
                    hasSetStatus = true;
                    continue;
                }
                if (ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) {
                    if (!"ServiceTask".equals(stateInstance.getType()) || !stateInstance.isForUpdate() || stateInstance.isForCompensation()) continue;
                    hasSuccessUpdateService = true;
                    continue;
                }
                if (ExecutionStatus.SK.equals((Object)stateInstance.getStatus())) continue;
                hasUnsuccessService = true;
            }
            if (!hasSetStatus && hasUnsuccessService) {
                if (hasSuccessUpdateService) {
                    stateMachineInstance.setStatus(ExecutionStatus.UN);
                } else {
                    stateMachineInstance.setStatus(ExecutionStatus.FA);
                }
                hasSetStatus = true;
            }
        }
        return hasSetStatus;
    }

    public static void setMachineStatusBasedOnException(StateMachineInstance stateMachineInstance, Exception exp) {
        if (exp == null) {
            stateMachineInstance.setStatus(ExecutionStatus.SU);
        } else if (exp instanceof EngineExecutionException && FrameworkErrorCode.StateMachineExecutionTimeout.equals((Object)((EngineExecutionException)exp).getErrcode())) {
            stateMachineInstance.setStatus(ExecutionStatus.UN);
        } else {
            ExceptionUtils.NetExceptionType t = ExceptionUtils.getNetExceptionType(exp);
            if (t != null) {
                if (t.equals((Object)ExceptionUtils.NetExceptionType.CONNECT_EXCEPTION) || t.equals((Object)ExceptionUtils.NetExceptionType.CONNECT_TIMEOUT_EXCEPTION) || t.equals((Object)ExceptionUtils.NetExceptionType.NOT_NET_EXCEPTION)) {
                    stateMachineInstance.setStatus(ExecutionStatus.FA);
                } else if (t.equals((Object)ExceptionUtils.NetExceptionType.READ_TIMEOUT_EXCEPTION)) {
                    stateMachineInstance.setStatus(ExecutionStatus.UN);
                }
            } else {
                stateMachineInstance.setStatus(ExecutionStatus.UN);
            }
        }
    }

    @Override
    public void decideOnEndState(ProcessContext context, StateMachineInstance stateMachineInstance, Exception exp) {
        if (ExecutionStatus.RU.equals((Object)stateMachineInstance.getCompensationStatus())) {
            CompensationHolder compensationHolder = CompensationHolder.getCurrent(context, true);
            DefaultStatusDecisionStrategy.decideMachineCompensateStatus(stateMachineInstance, compensationHolder);
        } else {
            Object failEndStateFlag = context.getVariable("_fail_end_state_flag_");
            boolean isComeFromFailEndState = failEndStateFlag != null && (Boolean)failEndStateFlag != false;
            this.decideMachineForwardExecutionStatus(stateMachineInstance, exp, isComeFromFailEndState);
        }
        if (stateMachineInstance.getCompensationStatus() != null && "forward".equals(context.getVariable("_operation_name_")) && ExecutionStatus.SU.equals((Object)stateMachineInstance.getStatus())) {
            stateMachineInstance.setCompensationStatus(ExecutionStatus.FA);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("StateMachine Instance[id:{},name:{}] execute finish with status[{}], compensation status [{}].", new Object[]{stateMachineInstance.getId(), stateMachineInstance.getStateMachine().getName(), stateMachineInstance.getStatus(), stateMachineInstance.getCompensationStatus()});
        }
    }

    @Override
    public void decideOnTaskStateFail(ProcessContext context, StateMachineInstance stateMachineInstance, Exception exp) {
        if (!this.decideMachineForwardExecutionStatus(stateMachineInstance, exp, true)) {
            stateMachineInstance.setCompensationStatus(ExecutionStatus.UN);
        }
    }

    @Override
    public boolean decideMachineForwardExecutionStatus(StateMachineInstance stateMachineInstance, Exception exp, boolean specialPolicy) {
        boolean result = false;
        if (stateMachineInstance.getStatus() == null || ExecutionStatus.RU.equals((Object)stateMachineInstance.getStatus())) {
            result = true;
            List<StateInstance> stateList = stateMachineInstance.getStateList();
            boolean hasSetStatus = DefaultStatusDecisionStrategy.setMachineStatusBasedOnStateList(stateMachineInstance, stateList);
            if (!hasSetStatus) {
                DefaultStatusDecisionStrategy.setMachineStatusBasedOnException(stateMachineInstance, exp);
            }
            if (specialPolicy && ExecutionStatus.SU.equals((Object)stateMachineInstance.getStatus())) {
                for (StateInstance stateInstance : stateMachineInstance.getStateList()) {
                    if (stateInstance.isIgnoreStatus() || !stateInstance.isForUpdate() && !stateInstance.isForCompensation()) continue;
                    stateMachineInstance.setStatus(ExecutionStatus.UN);
                    break;
                }
                if (ExecutionStatus.SU.equals((Object)stateMachineInstance.getStatus())) {
                    stateMachineInstance.setStatus(ExecutionStatus.FA);
                }
            }
        }
        return result;
    }
}

