/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.protobuf.convertor;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.MergeResultMessage;
import io.seata.serializer.protobuf.convertor.PbConvertor;
import io.seata.serializer.protobuf.generated.AbstractMessageProto;
import io.seata.serializer.protobuf.generated.MergedResultMessageProto;
import io.seata.serializer.protobuf.generated.MessageTypeProto;
import io.seata.serializer.protobuf.manager.ProtobufConvertManager;
import java.util.ArrayList;
import java.util.List;

public class MergeResultMessageConvertor
implements PbConvertor<MergeResultMessage, MergedResultMessageProto> {
    @Override
    public MergedResultMessageProto convert2Proto(MergeResultMessage mergeResultMessage) {
        short typeCode = mergeResultMessage.getTypeCode();
        AbstractMessageProto abstractMessage = AbstractMessageProto.newBuilder().setMessageType(MessageTypeProto.forNumber(typeCode)).build();
        ArrayList<Any> lists = new ArrayList<Any>();
        for (AbstractResultMessage msg : mergeResultMessage.msgs) {
            PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchConvertor(msg.getClass().getName());
            lists.add(Any.pack((Message)((Message)pbConvertor.convert2Proto(msg))));
        }
        MergedResultMessageProto mergedWarpMessageProto = MergedResultMessageProto.newBuilder().setAbstractMessage(abstractMessage).addAllMsgs(lists).build();
        return mergedWarpMessageProto;
    }

    @Override
    public MergeResultMessage convert2Model(MergedResultMessageProto mergedResultMessageProto) {
        MergeResultMessage result = new MergeResultMessage();
        List<Any> anys = mergedResultMessageProto.getMsgsList();
        ArrayList<AbstractResultMessage> temp = new ArrayList<AbstractResultMessage>();
        for (Any any : anys) {
            Class clazz;
            if (!any.is(clazz = ProtobufConvertManager.getInstance().fetchProtoClass(MergeResultMessageConvertor.getTypeNameFromTypeUrl(any.getTypeUrl())))) continue;
            try {
                Message ob = any.unpack(clazz);
                PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchReversedConvertor(clazz.getName());
                Object model = pbConvertor.convert2Model(ob);
                temp.add((AbstractResultMessage)model);
            }
            catch (InvalidProtocolBufferException e) {
                throw new ShouldNeverHappenException(e);
            }
        }
        result.setMsgs(temp.toArray(new AbstractResultMessage[temp.size()]));
        return result;
    }

    private static String getTypeNameFromTypeUrl(String typeUrl) {
        int pos = typeUrl.lastIndexOf(47);
        return pos == -1 ? "" : typeUrl.substring(pos + 1);
    }
}

