/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.utils;

import io.seata.saga.engine.AsyncCallback;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.utils.ExceptionUtils;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionUtils.class);

    public static String generateParentId(StateInstance stateInstance) {
        return stateInstance.getMachineInstanceId() + ":" + stateInstance.getId();
    }

    public static void endStateMachine(ProcessContext context) {
        AsyncCallback callback;
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        stateMachineInstance.setGmtEnd(new Date());
        Exception exp = (Exception)context.getVariable("currentException");
        if (exp != null) {
            stateMachineInstance.setException(exp);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exception Occurred: " + exp);
            }
        }
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        stateMachineConfig.getStatusDecisionStrategy().decideOnEndState(context, stateMachineInstance, exp);
        stateMachineInstance.getEndParams().putAll((Map)context.getVariable("context"));
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        instruction.setEnd(true);
        stateMachineInstance.setRunning(false);
        stateMachineInstance.setGmtEnd(new Date());
        if (stateMachineInstance.getStateMachine().isPersist() && stateMachineConfig.getStateLogStore() != null) {
            stateMachineConfig.getStateLogStore().recordStateMachineFinished(stateMachineInstance, context);
        }
        if ((callback = (AsyncCallback)context.getVariable("_async_callback_")) != null) {
            if (exp != null) {
                callback.onError(context, stateMachineInstance, exp);
            } else {
                callback.onFinished(context, stateMachineInstance);
            }
        }
    }

    public static void failStateMachine(ProcessContext context, Exception exp) {
        AsyncCallback callback;
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        stateMachineConfig.getStatusDecisionStrategy().decideOnTaskStateFail(context, stateMachineInstance, exp);
        stateMachineInstance.getEndParams().putAll((Map)context.getVariable("context"));
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        instruction.setEnd(true);
        stateMachineInstance.setRunning(false);
        stateMachineInstance.setGmtEnd(new Date());
        stateMachineInstance.setException(exp);
        if (stateMachineInstance.getStateMachine().isPersist() && stateMachineConfig.getStateLogStore() != null) {
            stateMachineConfig.getStateLogStore().recordStateMachineFinished(stateMachineInstance, context);
        }
        if ((callback = (AsyncCallback)context.getVariable("_async_callback_")) != null) {
            callback.onError(context, stateMachineInstance, exp);
        }
    }

    public static boolean isTimeout(Date gmtUpdated, int timeoutMillis) {
        if (gmtUpdated == null || timeoutMillis < 0) {
            return false;
        }
        return System.currentTimeMillis() - gmtUpdated.getTime() > (long)timeoutMillis;
    }
}

