/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import com.alibaba.fastjson.JSON;
import io.seata.common.util.IOUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.model.Result;
import io.seata.rm.datasource.DataCompareUtils;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.KeyType;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.SQLUndoLog;
import io.seata.rm.datasource.util.JdbcUtils;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUndoExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUndoExecutor.class);
    private static final String CHECK_SQL_TEMPLATE = "SELECT * FROM %s WHERE %s in (%s)";
    public static final boolean IS_UNDO_DATA_VALIDATION_ENABLE = ConfigurationFactory.getInstance().getBoolean("client.undo.dataValidation", true);
    protected SQLUndoLog sqlUndoLog;

    protected abstract String buildUndoSQL();

    public AbstractUndoExecutor(SQLUndoLog sqlUndoLog) {
        this.sqlUndoLog = sqlUndoLog;
    }

    public SQLUndoLog getSqlUndoLog() {
        return this.sqlUndoLog;
    }

    public void executeOn(Connection conn) throws SQLException {
        if (IS_UNDO_DATA_VALIDATION_ENABLE && !this.dataValidationAndGoOn(conn)) {
            return;
        }
        try {
            String undoSQL = this.buildUndoSQL();
            PreparedStatement undoPST = conn.prepareStatement(undoSQL);
            TableRecords undoRows = this.getUndoRows();
            for (Row undoRow : undoRows.getRows()) {
                ArrayList<Field> undoValues = new ArrayList<Field>();
                Field pkValue = null;
                for (Field field : undoRow.getFields()) {
                    if (field.getKeyType() == KeyType.PRIMARY_KEY) {
                        pkValue = field;
                        continue;
                    }
                    undoValues.add(field);
                }
                this.undoPrepare(undoPST, undoValues, pkValue);
                undoPST.executeUpdate();
            }
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new SQLException(ex);
        }
    }

    protected void undoPrepare(PreparedStatement undoPST, ArrayList<Field> undoValues, Field pkValue) throws SQLException {
        int undoIndex = 0;
        for (Field undoValue : undoValues) {
            ++undoIndex;
            if (undoValue.getType() == JDBCType.BLOB.getVendorTypeNumber().intValue()) {
                SerialBlob serialBlob = (SerialBlob)undoValue.getValue();
                if (serialBlob != null) {
                    undoPST.setBlob(undoIndex, serialBlob.getBinaryStream());
                    continue;
                }
                undoPST.setObject(undoIndex, null);
                continue;
            }
            if (undoValue.getType() == JDBCType.CLOB.getVendorTypeNumber().intValue()) {
                SerialClob serialClob = (SerialClob)undoValue.getValue();
                if (serialClob != null) {
                    undoPST.setClob(undoIndex, serialClob.getCharacterStream());
                    continue;
                }
                undoPST.setObject(undoIndex, null);
                continue;
            }
            if (undoValue.getType() == JDBCType.OTHER.getVendorTypeNumber().intValue()) {
                undoPST.setObject(undoIndex, undoValue.getValue());
                continue;
            }
            undoPST.setObject(undoIndex, undoValue.getValue(), undoValue.getType());
        }
        undoPST.setObject(++undoIndex, pkValue.getValue(), pkValue.getType());
    }

    protected abstract TableRecords getUndoRows();

    protected boolean dataValidationAndGoOn(Connection conn) throws SQLException {
        TableRecords afterRecords;
        TableRecords beforeRecords = this.sqlUndoLog.getBeforeImage();
        Result<Boolean> beforeEqualsAfterResult = DataCompareUtils.isRecordsEquals(beforeRecords, afterRecords = this.sqlUndoLog.getAfterImage());
        if (beforeEqualsAfterResult.getResult().booleanValue()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stop rollback because there is no data change between the before data snapshot and the after data snapshot.");
            }
            return false;
        }
        TableRecords currentRecords = this.queryCurrentRecords(conn);
        Result<Boolean> afterEqualsCurrentResult = DataCompareUtils.isRecordsEquals(afterRecords, currentRecords);
        if (!afterEqualsCurrentResult.getResult().booleanValue()) {
            Result<Boolean> beforeEqualsCurrentResult = DataCompareUtils.isRecordsEquals(beforeRecords, currentRecords);
            if (beforeEqualsCurrentResult.getResult().booleanValue()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Stop rollback because there is no data change between the before data snapshot and the current data snapshot.");
                }
                return false;
            }
            if (LOGGER.isInfoEnabled() && StringUtils.isNotBlank(afterEqualsCurrentResult.getErrMsg())) {
                LOGGER.info(afterEqualsCurrentResult.getErrMsg(), afterEqualsCurrentResult.getErrMsgParams());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("check dirty datas failed, old and new data are not equal,tableName:[" + this.sqlUndoLog.getTableName() + "],oldRows:[" + JSON.toJSONString(afterRecords.getRows()) + "],newRows:[" + JSON.toJSONString(currentRecords.getRows()) + "].");
            }
            throw new SQLException("Has dirty records when undo.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableRecords queryCurrentRecords(Connection conn) throws SQLException {
        TableRecords currentRecords;
        TableRecords undoRecords = this.getUndoRows();
        TableMeta tableMeta = undoRecords.getTableMeta();
        String pkName = tableMeta.getPkName();
        int pkType = tableMeta.getColumnMeta(pkName).getDataType();
        Object[] pkValues = this.parsePkValues(this.getUndoRows());
        if (pkValues.length == 0) {
            return TableRecords.empty(tableMeta);
        }
        StringBuilder replace = new StringBuilder();
        for (int i = 0; i < pkValues.length; ++i) {
            replace.append("?,");
        }
        String dbType = this.getDbType(conn);
        String checkSQL = String.format(CHECK_SQL_TEMPLATE, this.sqlUndoLog.getTableName(), tableMeta.getEscapePkName(dbType), replace.substring(0, replace.length() - 1));
        PreparedStatement statement = null;
        ResultSet checkSet = null;
        try {
            statement = conn.prepareStatement(checkSQL);
            for (int i = 1; i <= pkValues.length; ++i) {
                statement.setObject(i, pkValues[i - 1], pkType);
            }
            checkSet = statement.executeQuery();
            currentRecords = TableRecords.buildRecords(tableMeta, checkSet);
        }
        catch (Throwable throwable) {
            IOUtil.close(checkSet, statement);
            throw throwable;
        }
        IOUtil.close(checkSet, statement);
        return currentRecords;
    }

    protected Object[] parsePkValues(TableRecords records) {
        String pkName = records.getTableMeta().getPkName();
        List<Row> undoRows = records.getRows();
        Object[] pkValues = new Object[undoRows.size()];
        for (int i = 0; i < undoRows.size(); ++i) {
            List<Field> fields = undoRows.get(i).getFields();
            if (fields == null) continue;
            for (Field field : fields) {
                if (!StringUtils.equalsIgnoreCase(pkName, field.getName())) continue;
                pkValues[i] = field.getValue();
            }
        }
        return pkValues;
    }

    protected String getDbType(Connection conn) throws SQLException {
        return JdbcUtils.getDbType(conn.getMetaData().getURL());
    }
}

