/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation.datasource;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.spring.annotation.datasource.DataSourceProxyHolder;
import io.seata.spring.util.SpringProxyUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.sql.DataSource;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SeataDataSourceBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataDataSourceBeanPostProcessor.class);
    private final boolean useJdkProxy;

    public SeataDataSourceBeanPostProcessor(boolean useJdkProxy) {
        this.useJdkProxy = useJdkProxy;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource && !(bean instanceof DataSourceProxy)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Auto proxy of [{}]", (Object)beanName);
            }
            return this.proxyDataSource(bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (bean instanceof DataSourceProxy) {
            throw new ShouldNeverHappenException("Auto proxy of DataSource can't be enabled as you've created a DataSourceProxy bean.Please consider removing DataSourceProxy bean or disabling auto proxy of DataSource.");
        }
        return bean;
    }

    private Object proxyDataSource(Object originBean) {
        DataSourceProxy dataSourceProxy = DataSourceProxyHolder.get().putDataSource((DataSource)originBean);
        if (this.useJdkProxy) {
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), SpringProxyUtils.getAllInterfaces(originBean), (proxy, method, args) -> this.handleMethodProxy(dataSourceProxy, method, args, originBean));
        }
        return Enhancer.create(originBean.getClass(), (Callback)((MethodInterceptor)(proxy, method, args, methodProxy) -> this.handleMethodProxy(dataSourceProxy, method, args, originBean)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleMethodProxy(DataSourceProxy dataSourceProxy, Method method, Object[] args, Object originBean) throws InvocationTargetException, IllegalAccessException {
        Method m = BeanUtils.findDeclaredMethod(DataSourceProxy.class, (String)method.getName(), (Class[])method.getParameterTypes());
        if (null != m) {
            return m.invoke((Object)dataSourceProxy, args);
        }
        boolean oldAccessible = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object = method.invoke(originBean, args);
            return object;
        }
        finally {
            method.setAccessible(oldAccessible);
        }
    }
}

