/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.FrameworkException;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class DesignerJsonTransformer {
    public static Map<String, Object> toStandardJson(Map<String, Object> designerJsonObject) {
        if (!DesignerJsonTransformer.isDesignerJson(designerJsonObject)) {
            return designerJsonObject;
        }
        JSONObject machineJsonObject = new JSONObject(true);
        List nodes = (List)designerJsonObject.get("nodes");
        if (nodes != null && nodes.size() > 0) {
            HashMap<String, JSONObject> nodeMap = new HashMap<String, JSONObject>(nodes.size());
            for (Object node : nodes) {
                JSONObject nodeObj = (JSONObject)node;
                DesignerJsonTransformer.transformNode(machineJsonObject, nodeMap, nodeObj);
            }
            List edges = (List)designerJsonObject.get("edges");
            if (edges != null && edges.size() > 0) {
                for (Object edge : edges) {
                    JSONObject edgeObj = (JSONObject)edge;
                    DesignerJsonTransformer.transformEdge(machineJsonObject, nodes, nodeMap, edgeObj);
                }
            }
        }
        return machineJsonObject;
    }

    private static void transformNode(JSONObject machineJsonObject, Map<String, JSONObject> nodeMap, JSONObject nodeObj) {
        nodeMap.put(nodeObj.getString("id"), nodeObj);
        String type = nodeObj.getString("stateType");
        JSONObject propsObj = (JSONObject)nodeObj.get((Object)"stateProps");
        if ("Start".equals(type)) {
            if (propsObj != null && propsObj.containsKey((Object)"StateMachine")) {
                machineJsonObject.putAll((Map)propsObj.getJSONObject("StateMachine"));
            }
        } else if (!"Catch".equals(type)) {
            JSONObject states = machineJsonObject.getJSONObject("States");
            if (states == null) {
                states = new JSONObject(true);
                machineJsonObject.put("States", (Object)states);
            }
            JSONObject stateJsonObject = new JSONObject(true);
            String stateId = nodeObj.getString("stateId");
            if (states.containsKey((Object)stateId)) {
                throw new RuntimeException("Transform designer json to standard json failed, stateId[" + stateId + "] already exists, pls rename it.");
            }
            String comment = nodeObj.getString("label");
            if (StringUtils.hasLength((String)comment)) {
                stateJsonObject.put("Comment", (Object)comment);
            }
            if (propsObj != null) {
                stateJsonObject.putAll((Map)propsObj);
            }
            states.put(stateId, (Object)stateJsonObject);
            String stateType = nodeObj.getString("stateType");
            if ("Compensation".equals(stateType)) {
                stateJsonObject.put("Type", (Object)"ServiceTask");
            } else {
                stateJsonObject.put("Type", (Object)stateType);
            }
        }
    }

    private static void transformEdge(JSONObject machineJsonObject, List<Object> nodes, Map<String, JSONObject> nodeMap, JSONObject edgeObj) {
        String sourceId = edgeObj.getString("source");
        String targetId = edgeObj.getString("target");
        if (StringUtils.hasLength((String)sourceId)) {
            JSONObject sourceNode = nodeMap.get(sourceId);
            JSONObject targetNode = nodeMap.get(targetId);
            if (sourceNode != null) {
                JSONObject states = machineJsonObject.getJSONObject("States");
                JSONObject sourceState = states.getJSONObject(sourceNode.getString("stateId"));
                String targetStateId = targetNode.getString("stateId");
                String sourceType = sourceNode.getString("stateType");
                if ("Start".equals(sourceType)) {
                    machineJsonObject.put("StartState", (Object)targetStateId);
                    machineJsonObject.put("States", machineJsonObject.remove((Object)"States"));
                } else if ("ServiceTask".equals(sourceType)) {
                    if (targetNode != null && "Compensation".equals(targetNode.getString("stateType"))) {
                        sourceState.put("CompensateState", (Object)targetStateId);
                    } else {
                        sourceState.put("Next", (Object)targetStateId);
                    }
                } else if ("Catch".equals(sourceType)) {
                    JSONObject edgeProps;
                    JSONObject catchAttachedNode = DesignerJsonTransformer.getCatchAttachedNode(sourceNode, nodes);
                    if (catchAttachedNode == null) {
                        throw new RuntimeException("'Catch' node[" + sourceNode.get((Object)"id") + "] is not attached on a 'ServiceTask'");
                    }
                    JSONObject catchAttachedState = (JSONObject)states.get((Object)catchAttachedNode.getString("stateId"));
                    JSONArray catches = catchAttachedState.getJSONArray("Catch");
                    if (catches == null) {
                        catches = new JSONArray();
                        catchAttachedState.put("Catch", (Object)catches);
                    }
                    if ((edgeProps = (JSONObject)edgeObj.get((Object)"stateProps")) != null) {
                        JSONObject catchObj = new JSONObject(true);
                        catchObj.put("Exceptions", edgeProps.get((Object)"Exceptions"));
                        catchObj.put("Next", (Object)targetStateId);
                        catches.add((Object)catchObj);
                    }
                } else if ("Choice".equals(sourceType)) {
                    JSONObject edgeProps;
                    JSONArray choices = sourceState.getJSONArray("Choices");
                    if (choices == null) {
                        choices = new JSONArray();
                        sourceState.put("Choices", (Object)choices);
                    }
                    if ((edgeProps = (JSONObject)edgeObj.get((Object)"stateProps")) != null) {
                        if (Boolean.TRUE.equals(edgeProps.getBoolean("Default"))) {
                            sourceState.put("Default", (Object)targetStateId);
                        } else {
                            JSONObject choiceObj = new JSONObject(true);
                            choiceObj.put("Expression", edgeProps.get((Object)"Expression"));
                            choiceObj.put("Next", (Object)targetStateId);
                            choices.add((Object)choiceObj);
                        }
                    }
                } else {
                    sourceState.put("Next", (Object)targetStateId);
                }
            }
        }
    }

    public static boolean isDesignerJson(Map<String, Object> jsonObject) {
        return jsonObject != null && jsonObject.containsKey("nodes") && jsonObject.containsKey("edges");
    }

    private static JSONObject getCatchAttachedNode(JSONObject catchNode, List<Object> nodes) {
        int catchNodeX = catchNode.getInteger("x");
        int catchNodeY = catchNode.getInteger("y");
        String catchSize = catchNode.getString("size");
        String[] catchSizes = catchSize.split("\\*");
        int catchWidth = Integer.parseInt(catchSizes[0]);
        int catchHeight = Integer.parseInt(catchSizes[1]);
        for (Object node : nodes) {
            JSONObject nodeObj = (JSONObject)node;
            if (catchNode == nodeObj || !"ServiceTask".equals(nodeObj.get((Object)"stateType"))) continue;
            int nodeX = nodeObj.getInteger("x");
            int nodeY = nodeObj.getInteger("y");
            String nodeSize = nodeObj.getString("size");
            String[] nodeSizes = nodeSize.split("\\*");
            int nodeWidth = Integer.parseInt(nodeSizes[0]);
            int nodeHeight = Integer.parseInt(nodeSizes[1]);
            if (!DesignerJsonTransformer.isBordersCoincided(catchNodeX, nodeX, catchWidth, nodeWidth) || !DesignerJsonTransformer.isBordersCoincided(catchNodeY, nodeY, catchHeight, nodeHeight)) continue;
            return nodeObj;
        }
        return null;
    }

    private static boolean isBordersCoincided(int xyA, int xyB, int lengthA, int lengthB) {
        int centerPointLength = xyA > xyB ? xyA - xyB : xyB - xyA;
        return (lengthA + lengthB) / 2 > centerPointLength;
    }

    public static String generateTracingGraphJson(StateMachineInstance stateMachineInstance) {
        if (stateMachineInstance == null) {
            throw new FrameworkException("StateMachineInstance is not exits", FrameworkErrorCode.StateMachineInstanceNotExists);
        }
        String stateMachineJson = stateMachineInstance.getStateMachine().getContent();
        if (StringUtils.isEmpty((Object)stateMachineJson)) {
            throw new FrameworkException("Cannot get StateMachine Json", FrameworkErrorCode.ObjectNotExists);
        }
        JSONObject stateMachineJsonObj = JSON.parseObject((String)stateMachineJson, (Feature[])new Feature[]{Feature.IgnoreAutoType, Feature.OrderedField});
        if (!DesignerJsonTransformer.isDesignerJson((Map<String, Object>)stateMachineJsonObj)) {
            throw new FrameworkException("StateMachine Json is not generated by Designer", FrameworkErrorCode.InvalidConfiguration);
        }
        HashMap<String, ArrayList<StateInstance>> stateInstanceMapGroupByName = new HashMap<String, ArrayList<StateInstance>>(stateMachineInstance.getStateMap().size());
        for (String id : stateMachineInstance.getStateMap().keySet()) {
            StateInstance stateInstance = stateMachineInstance.getStateMap().get(id);
            ArrayList<StateInstance> stateInstanceList = (ArrayList<StateInstance>)stateInstanceMapGroupByName.get(stateInstance.getName());
            if (stateInstanceList == null) {
                stateInstanceList = new ArrayList<StateInstance>();
                stateInstanceMapGroupByName.put(stateInstance.getName(), stateInstanceList);
            }
            stateInstanceList.add(stateInstance);
        }
        JSONArray nodesArray = stateMachineJsonObj.getJSONArray("nodes");
        for (Object nodeObj : nodesArray) {
            JSONObject style;
            List stateInstanceList;
            JSONObject node = (JSONObject)nodeObj;
            String stateId = node.getString("stateId");
            String stateType = node.getString("stateType");
            if ("ServiceTask".equals(stateType) || "SubStateMachine".equals(stateType) || "Compensation".equals(stateType)) {
                node.remove((Object)"color");
            }
            if ((stateInstanceList = (List)stateInstanceMapGroupByName.get(stateId)) == null || stateInstanceList.size() <= 0) continue;
            StateInstance stateInstance = null;
            if (stateInstanceList.size() == 1) {
                stateInstance = (StateInstance)stateInstanceList.get(0);
            } else {
                for (StateInstance stateInst : stateInstanceList) {
                    if (stateInstance != null && !stateInst.getGmtStarted().after(stateInstance.getGmtStarted())) continue;
                    stateInstance = stateInst;
                }
            }
            node.put("stateInstanceId", (Object)stateInstance.getId());
            node.put("stateInstanceStatus", (Object)stateInstance.getStatus());
            if (ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) {
                node.put("color", (Object)"green");
                style = new JSONObject();
                style.put("fill", (Object)"#00D73E");
                style.put("lineWidth", (Object)2);
                node.put("style", (Object)style);
                continue;
            }
            node.put("color", (Object)"red");
            style = new JSONObject();
            style.put("fill", (Object)"#FF7777");
            style.put("lineWidth", (Object)2);
            node.put("style", (Object)style);
        }
        return stateMachineJsonObj.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }
}

