/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.config;

import io.seata.config.ConfigurationFactory;
import io.seata.saga.engine.impl.DefaultStateMachineConfig;
import io.seata.saga.engine.store.db.DbAndReportTcStateLogStore;
import io.seata.saga.engine.store.db.DbStateLangStore;
import io.seata.saga.tm.DefaultSagaTransactionalTemplate;
import io.seata.saga.tm.SagaTransactionalTemplate;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.DisposableBean;

public class DbStateMachineConfig
extends DefaultStateMachineConfig
implements DisposableBean {
    private DataSource dataSource;
    private String applicationId;
    private String txServiceGroup;
    private String tablePrefix = "seata_";
    private String dbType;
    private SagaTransactionalTemplate sagaTransactionalTemplate;
    private boolean rmReportSuccessEnable = ConfigurationFactory.getInstance().getBoolean("client.rm.reportSuccessEnable", false);

    public static String getDbTypeFromDataSource(DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            DatabaseMetaData metaData = con.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.dbType = DbStateMachineConfig.getDbTypeFromDataSource(this.dataSource);
        if (this.getStateLogStore() == null) {
            DbAndReportTcStateLogStore dbStateLogStore = new DbAndReportTcStateLogStore();
            dbStateLogStore.setDataSource(this.dataSource);
            dbStateLogStore.setTablePrefix(this.tablePrefix);
            dbStateLogStore.setDbType(this.dbType);
            dbStateLogStore.setDefaultTenantId(this.getDefaultTenantId());
            dbStateLogStore.setSeqGenerator(this.getSeqGenerator());
            if (this.sagaTransactionalTemplate == null) {
                DefaultSagaTransactionalTemplate defaultSagaTransactionalTemplate = new DefaultSagaTransactionalTemplate();
                defaultSagaTransactionalTemplate.setApplicationContext(this.getApplicationContext());
                defaultSagaTransactionalTemplate.setApplicationId(this.applicationId);
                defaultSagaTransactionalTemplate.setTxServiceGroup(this.txServiceGroup);
                defaultSagaTransactionalTemplate.afterPropertiesSet();
                this.sagaTransactionalTemplate = defaultSagaTransactionalTemplate;
            }
            dbStateLogStore.setSagaTransactionalTemplate(this.sagaTransactionalTemplate);
            this.setStateLogStore(dbStateLogStore);
        }
        if (this.getStateLangStore() == null) {
            DbStateLangStore dbStateLangStore = new DbStateLangStore();
            dbStateLangStore.setDataSource(this.dataSource);
            dbStateLangStore.setTablePrefix(this.tablePrefix);
            dbStateLangStore.setDbType(this.dbType);
            this.setStateLangStore(dbStateLangStore);
        }
        super.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        if (this.sagaTransactionalTemplate != null && this.sagaTransactionalTemplate instanceof DisposableBean) {
            ((DisposableBean)this.sagaTransactionalTemplate).destroy();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTxServiceGroup() {
        return this.txServiceGroup;
    }

    public void setTxServiceGroup(String txServiceGroup) {
        this.txServiceGroup = txServiceGroup;
    }

    public void setSagaTransactionalTemplate(SagaTransactionalTemplate sagaTransactionalTemplate) {
        this.sagaTransactionalTemplate = sagaTransactionalTemplate;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public boolean isRmReportSuccessEnable() {
        return this.rmReportSuccessEnable;
    }

    public void setRmReportSuccessEnable(boolean rmReportSuccessEnable) {
        this.rmReportSuccessEnable = rmReportSuccessEnable;
    }
}

