/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry.zk;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.NetUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegisterServiceImpl
implements RegistryService<IZkChildListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperRegisterServiceImpl.class);
    private static volatile ZookeeperRegisterServiceImpl instance;
    private static volatile ZkClient zkClient;
    private static final Configuration FILE_CONFIG;
    private static final String ZK_PATH_SPLIT_CHAR = "/";
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_CLUSTER = "cluster";
    private static final String REGISTRY_TYPE = "zk";
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String AUTH_USERNAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String SESSION_TIME_OUT_KEY = "session.timeout";
    private static final String CONNECT_TIME_OUT_KEY = "connect.timeout";
    private static final String FILE_CONFIG_KEY_PREFIX = "registry.zk.";
    private static final String ROOT_PATH = "/registry/zk/";
    private static final String ROOT_PATH_WITHOUT_SUFFIX = "/registry/zk";
    private static final ConcurrentMap<String, List<InetSocketAddress>> CLUSTER_ADDRESS_MAP;
    private static final ConcurrentMap<String, List<IZkChildListener>> LISTENER_SERVICE_MAP;
    private static final int REGISTERED_PATH_SET_SIZE = 1;
    private static final Set<String> REGISTERED_PATH_SET;

    private ZookeeperRegisterServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ZookeeperRegisterServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<ZookeeperRegisterServiceImpl> clazz = ZookeeperRegisterServiceImpl.class;
        synchronized (ZookeeperRegisterServiceImpl.class) {
            if (null != instance) return instance;
            instance = new ZookeeperRegisterServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress(address);
        String path = this.getRegisterPathByPath(address);
        this.doRegister(path);
    }

    private boolean doRegister(String path) {
        if (this.checkExists(path)) {
            return false;
        }
        this.createParentIfNotPresent(path);
        this.getClientInstance().createEphemeral(path, (Object)true);
        REGISTERED_PATH_SET.add(path);
        return true;
    }

    private void createParentIfNotPresent(String path) {
        String parent;
        int i = path.lastIndexOf(47);
        if (i > 0 && !this.checkExists(parent = path.substring(0, i))) {
            this.getClientInstance().createPersistent(parent);
        }
    }

    private boolean checkExists(String path) {
        return this.getClientInstance().exists(path);
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
        NetUtil.validAddress(address);
        String path = this.getRegisterPathByPath(address);
        this.getClientInstance().delete(path);
        REGISTERED_PATH_SET.remove(path);
    }

    @Override
    public void subscribe(String cluster, IZkChildListener listener) throws Exception {
        if (null == cluster) {
            return;
        }
        String path = ROOT_PATH + cluster;
        if (!this.getClientInstance().exists(path)) {
            this.getClientInstance().createPersistent(path);
        }
        this.getClientInstance().subscribeChildChanges(path, listener);
        LISTENER_SERVICE_MAP.putIfAbsent(cluster, new CopyOnWriteArrayList());
        ((List)LISTENER_SERVICE_MAP.get(cluster)).add(listener);
    }

    @Override
    public void unsubscribe(String cluster, IZkChildListener listener) throws Exception {
        if (null == cluster) {
            return;
        }
        String path = ROOT_PATH + cluster;
        if (this.getClientInstance().exists(path)) {
            this.getClientInstance().unsubscribeChildChanges(path, listener);
            List subscribeList = (List)LISTENER_SERVICE_MAP.get(cluster);
            if (null != subscribeList) {
                List newSubscribeList = subscribeList.stream().filter(eventListener -> !eventListener.equals(listener)).collect(Collectors.toList());
                LISTENER_SERVICE_MAP.put(cluster, newSubscribeList);
            }
        }
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        String clusterName = this.getServiceGroup(key);
        if (null == clusterName) {
            return null;
        }
        return this.doLookup(clusterName);
    }

    List<InetSocketAddress> doLookup(String clusterName) throws Exception {
        boolean exist = this.getClientInstance().exists(ROOT_PATH + clusterName);
        if (!exist) {
            return null;
        }
        if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
            List childClusterPath = this.getClientInstance().getChildren(ROOT_PATH + clusterName);
            this.refreshClusterAddressMap(clusterName, childClusterPath);
            this.subscribeCluster(clusterName);
        }
        return (List)CLUSTER_ADDRESS_MAP.get(clusterName);
    }

    @Override
    public void close() throws Exception {
        this.getClientInstance().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ZkClient getClientInstance() {
        if (zkClient != null) return zkClient;
        Class<ZookeeperRegisterServiceImpl> clazz = ZookeeperRegisterServiceImpl.class;
        synchronized (ZookeeperRegisterServiceImpl.class) {
            if (null != zkClient) return zkClient;
            zkClient = this.buildZkClient(FILE_CONFIG.getConfig("registry.zk.serverAddr"), FILE_CONFIG.getInt("registry.zk.session.timeout"), FILE_CONFIG.getInt("registry.zk.connect.timeout"), FILE_CONFIG.getConfig("registry.zk.username"), FILE_CONFIG.getConfig("registry.zk.password"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zkClient;
        }
    }

    ZkClient buildZkClient(String address, int sessionTimeout, int connectTimeout, String ... authInfo) {
        ZkClient zkClient = new ZkClient(address, sessionTimeout, connectTimeout);
        if (!zkClient.exists(ROOT_PATH_WITHOUT_SUFFIX)) {
            zkClient.createPersistent(ROOT_PATH_WITHOUT_SUFFIX, true);
        }
        if (null != authInfo && authInfo.length == 2 && !StringUtils.isBlank(authInfo[0]) && !StringUtils.isBlank(authInfo[1])) {
            StringBuilder auth = new StringBuilder(authInfo[0]).append(":").append(authInfo[1]);
            zkClient.addAuthInfo("digest", auth.toString().getBytes());
        }
        zkClient.subscribeStateChanges(new IZkStateListener(){

            public void handleStateChanged(Watcher.Event.KeeperState keeperState) throws Exception {
            }

            public void handleNewSession() throws Exception {
                ZookeeperRegisterServiceImpl.this.recover();
            }

            public void handleSessionEstablishmentError(Throwable throwable) throws Exception {
            }
        });
        return zkClient;
    }

    private void recover() throws Exception {
        if (!REGISTERED_PATH_SET.isEmpty()) {
            REGISTERED_PATH_SET.forEach(this::doRegister);
        }
        if (!LISTENER_SERVICE_MAP.isEmpty()) {
            HashMap<String, List<IZkChildListener>> listenerMap = new HashMap<String, List<IZkChildListener>>(LISTENER_SERVICE_MAP);
            for (Map.Entry listenerEntry : listenerMap.entrySet()) {
                List iZkChildListeners = (List)listenerEntry.getValue();
                if (CollectionUtils.isEmpty(iZkChildListeners)) continue;
                for (IZkChildListener listener : iZkChildListeners) {
                    this.subscribe((String)listenerEntry.getKey(), listener);
                }
            }
        }
    }

    private void subscribeCluster(String cluster) throws Exception {
        this.subscribe(cluster, (parentPath, currentChilds) -> {
            String clusterName = parentPath.replace(ROOT_PATH, "");
            if (CollectionUtils.isEmpty(currentChilds) && CLUSTER_ADDRESS_MAP.get(clusterName) != null) {
                CLUSTER_ADDRESS_MAP.remove(clusterName);
            } else if (!CollectionUtils.isEmpty(currentChilds)) {
                this.refreshClusterAddressMap(clusterName, currentChilds);
            }
        });
    }

    private void refreshClusterAddressMap(String clusterName, List<String> instances) {
        ArrayList<InetSocketAddress> newAddressList = new ArrayList<InetSocketAddress>();
        if (instances == null) {
            CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
            return;
        }
        for (String path : instances) {
            try {
                String[] ipAndPort = path.split(":");
                newAddressList.add(new InetSocketAddress(ipAndPort[0], Integer.parseInt(ipAndPort[1])));
            }
            catch (Exception e) {
                LOGGER.warn("The cluster instance info is error, instance info:{}", (Object)path);
            }
        }
        CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
    }

    private String getClusterName() {
        String clusterConfigName = String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, REGISTRY_CLUSTER);
        return FILE_CONFIG.getConfig(clusterConfigName);
    }

    private String getRegisterPathByPath(InetSocketAddress address) {
        return ROOT_PATH + this.getClusterName() + ZK_PATH_SPLIT_CHAR + NetUtil.toStringAddress(address);
    }

    static {
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
        CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
        LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<IZkChildListener>>();
        REGISTERED_PATH_SET = Collections.synchronizedSet(new HashSet(1));
    }
}

