/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db;

import io.seata.common.exception.NotSupportYetException;
import io.seata.core.constants.DBType;

public class LogStoreSqls {
    public static final String GLOBAL_TABLE_PLACEHOLD = " #global_table# ";
    public static final String BRANCH_TABLE_PLACEHOLD = " #branch_table# ";
    public static final String PRAMETER_PLACEHOLD = " #PRAMETER_PLACEHOLD# ";
    public static final String ALL_GLOBAL_COLUMNS = "xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified";
    protected static final String ALL_BRANCH_COLUMNS = "xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified";
    public static final String INSERT_GLOBAL_TRANSACTION_MYSQL = "insert into  #global_table# (xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified)values(?, ?, ?, ?, ?, ?, ?, ?, ?, now(), now()) ";
    public static final String INSERT_GLOBAL_TRANSACTION_ORACLE = "insert into  #global_table# (xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified)values(?, ?, ?, ?, ?, ?, ?, ?, ?, sysdate, sysdate) ";
    public static final String INSERT_GLOBAL_TRANSACTION_POSTGRESQL = "insert into  #global_table# (xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified)values(?, ?, ?, ?, ?, ?, ?, ?, ?, now(), now()) ";
    public static final String UPDATE_GLOBAL_TRANSACTION_STATUS_MYSQL = "update  #global_table#  set status = ?, gmt_modified = now() where xid = ?";
    public static final String UPDATE_GLOBAL_TRANSACTION_STATUS_ORACLE = "update  #global_table#  set status = ?, gmt_modified = sysdate where xid = ?";
    public static final String UPDATE_GLOBAL_TRANSACTION_STATUS_POSTGRESQL = "update  #global_table#  set status = ?, gmt_modified = now() where xid = ?";
    public static final String DELETE_GLOBAL_TRANSACTION = "delete from  #global_table#  where xid = ?";
    public static final String QUERY_GLOBAL_TRANSACTION = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where xid = ?";
    public static final String QUERY_GLOBAL_TRANSACTION_BY_ID = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where transaction_id = ?";
    public static final String QUERY_GLOBAL_TRANSACTION_BY_STATUS_MYSQL = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where status in ( #PRAMETER_PLACEHOLD# ) order by gmt_modified limit ?";
    public static final String QUERY_GLOBAL_TRANSACTION_BY_STATUS_ORACLE = "select t.* from (  select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#   where status in ( #PRAMETER_PLACEHOLD# )  order by gmt_modified) t where ROWNUM <= ?";
    public static final String QUERY_GLOBAL_TRANSACTION_BY_STATUS_POSTGRESQL = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where status in ( #PRAMETER_PLACEHOLD# ) order by gmt_modified limit ?";
    public static final String QUERY_GLOBAL_TRANSACTION_FOR_RECOVERY_MYSQL = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where status in (0, 2, 3, 4, 5, 6, 7, 8, 10 ,12, 14) order by gmt_modified limit ?";
    public static final String QUERY_GLOBAL_TRANSACTION_FOR_RECOVERY_ORACLE = "select A.* from ( select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where status in (0, 2, 3, 4, 5, 6, 7, 8, 10 ,12, 14) order by gmt_modified ) A where ROWNUM <= ?";
    public static final String QUERY_GLOBAL_TRANSACTION_FOR_RECOVERY_POSTGRESQL = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where status in (0, 2, 3, 4, 5, 6, 7, 8, 10 ,12, 14) order by gmt_modified limit ?";
    public static final String INSERT_BRANCH_TRANSACTION_MYSQL = "insert into  #branch_table# (xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified)values (?, ?, ?, ?, ?, ?, ?, ?, ?, now(6), now(6))";
    public static final String INSERT_BRANCH_TRANSACTION_ORACLE = "insert into  #branch_table# (xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified)values (?, ?, ?, ?, ?, ?, ?, ?, ?, systimestamp, systimestamp)";
    public static final String INSERT_BRANCH_TRANSACTION_POSTGRESQL = "insert into  #branch_table# (xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified)values (?, ?, ?, ?, ?, ?, ?, ?, ?, now(), now())";
    public static final String UPDATE_BRANCH_TRANSACTION_STATUS_MYSQL = "update  #branch_table#  set status = ?, gmt_modified = now(6) where xid = ? and branch_id = ?";
    public static final String UPDATE_BRANCH_TRANSACTION_STATUS_ORACLE = "update  #branch_table#  set status = ?, gmt_modified = systimestamp where xid = ? and branch_id = ?";
    public static final String UPDATE_BRANCH_TRANSACTION_STATUS_POSTGRESQL = "update  #branch_table#  set status = ?, gmt_modified = now() where xid = ? and branch_id = ?";
    public static final String DELETE_BRANCH_TRANSACTION_BY_BRANCH_ID = "delete from  #branch_table#  where xid = ? and branch_id = ?";
    public static final String DELETE_BRANCH_TRANSACTION_BY_XID = "delete from  #branch_table#  where xid = ?";
    public static final String QUERY_BRANCH_TRANSACTION = "select xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified from  #branch_table#  where xid = ? order by gmt_create asc";
    public static final String QUERY_BRANCH_TRANSACTION_XIDS = "select xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified from  #branch_table#  where xid in ( #PRAMETER_PLACEHOLD# ) order by gmt_create asc";
    public static final String QUERY_MAX_TRANS_ID = "select max(transaction_id) from  #global_table#  where transaction_id < ? and transaction_id > ?";
    public static final String QUERY_MAX_BTANCH_ID = "select max(branch_id) from  #branch_table#  where branch_id < ? and branch_id > ?";

    public static String getInsertGlobalTransactionSQL(String globalTable, String dbType) {
        if (DBType.MYSQL.name().equalsIgnoreCase(dbType) || DBType.OCEANBASE.name().equalsIgnoreCase(dbType) || DBType.H2.name().equalsIgnoreCase(dbType)) {
            return "insert into  #global_table# (xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified)values(?, ?, ?, ?, ?, ?, ?, ?, ?, now(), now()) ".replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
        }
        if (DBType.ORACLE.name().equalsIgnoreCase(dbType)) {
            return INSERT_GLOBAL_TRANSACTION_ORACLE.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
        }
        if (DBType.POSTGRESQL.name().equalsIgnoreCase(dbType)) {
            return "insert into  #global_table# (xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified)values(?, ?, ?, ?, ?, ?, ?, ?, ?, now(), now()) ".replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
        }
        throw new NotSupportYetException("unknown dbType:" + dbType);
    }

    public static String getUpdateGlobalTransactionStatusSQL(String globalTable, String dbType) {
        if (DBType.MYSQL.name().equalsIgnoreCase(dbType) || DBType.OCEANBASE.name().equalsIgnoreCase(dbType) || DBType.H2.name().equalsIgnoreCase(dbType)) {
            return "update  #global_table#  set status = ?, gmt_modified = now() where xid = ?".replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
        }
        if (DBType.ORACLE.name().equalsIgnoreCase(dbType)) {
            return UPDATE_GLOBAL_TRANSACTION_STATUS_ORACLE.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
        }
        if (DBType.POSTGRESQL.name().equalsIgnoreCase(dbType)) {
            return "update  #global_table#  set status = ?, gmt_modified = now() where xid = ?".replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
        }
        throw new NotSupportYetException("unknown dbType:" + dbType);
    }

    public static String getDeleteGlobalTransactionSQL(String globalTable, String dbType) {
        return DELETE_GLOBAL_TRANSACTION.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
    }

    public static String getQueryGlobalTransactionSQL(String globalTable, String dbType) {
        return QUERY_GLOBAL_TRANSACTION.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
    }

    public static String getQueryGlobalTransactionSQLByTransactionId(String globalTable, String dbType) {
        return QUERY_GLOBAL_TRANSACTION_BY_ID.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
    }

    public static String getQueryGlobalTransactionSQLByStatus(String globalTable, String dbType, String paramsPlaceHolder) {
        if (DBType.MYSQL.name().equalsIgnoreCase(dbType) || DBType.OCEANBASE.name().equalsIgnoreCase(dbType) || DBType.H2.name().equalsIgnoreCase(dbType)) {
            return "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where status in ( #PRAMETER_PLACEHOLD# ) order by gmt_modified limit ?".replace(GLOBAL_TABLE_PLACEHOLD, globalTable).replace(PRAMETER_PLACEHOLD, paramsPlaceHolder);
        }
        if (DBType.ORACLE.name().equalsIgnoreCase(dbType)) {
            return QUERY_GLOBAL_TRANSACTION_BY_STATUS_ORACLE.replace(GLOBAL_TABLE_PLACEHOLD, globalTable).replace(PRAMETER_PLACEHOLD, paramsPlaceHolder);
        }
        if (DBType.POSTGRESQL.name().equalsIgnoreCase(dbType)) {
            return "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where status in ( #PRAMETER_PLACEHOLD# ) order by gmt_modified limit ?".replace(GLOBAL_TABLE_PLACEHOLD, globalTable).replace(PRAMETER_PLACEHOLD, paramsPlaceHolder);
        }
        throw new IllegalArgumentException("unknown database type");
    }

    public static String getQueryGlobalTransactionForRecoverySQL(String globalTable, String dbType) {
        if (DBType.MYSQL.name().equalsIgnoreCase(dbType) || DBType.OCEANBASE.name().equalsIgnoreCase(dbType) || DBType.H2.name().equalsIgnoreCase(dbType)) {
            return "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where status in (0, 2, 3, 4, 5, 6, 7, 8, 10 ,12, 14) order by gmt_modified limit ?".replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
        }
        if (DBType.ORACLE.name().equalsIgnoreCase(dbType)) {
            return QUERY_GLOBAL_TRANSACTION_FOR_RECOVERY_ORACLE.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
        }
        if (DBType.POSTGRESQL.name().equalsIgnoreCase(dbType)) {
            return "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  where status in (0, 2, 3, 4, 5, 6, 7, 8, 10 ,12, 14) order by gmt_modified limit ?".replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
        }
        throw new NotSupportYetException("unknown dbType:" + dbType);
    }

    public static String getInsertBranchTransactionSQL(String branchTable, String dbType) {
        if (DBType.MYSQL.name().equalsIgnoreCase(dbType) || DBType.OCEANBASE.name().equalsIgnoreCase(dbType) || DBType.H2.name().equalsIgnoreCase(dbType)) {
            return INSERT_BRANCH_TRANSACTION_MYSQL.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
        }
        if (DBType.ORACLE.name().equalsIgnoreCase(dbType)) {
            return INSERT_BRANCH_TRANSACTION_ORACLE.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
        }
        if (DBType.POSTGRESQL.name().equalsIgnoreCase(dbType)) {
            return INSERT_BRANCH_TRANSACTION_POSTGRESQL.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
        }
        throw new NotSupportYetException("unknown dbType:" + dbType);
    }

    public static String getUpdateBranchTransactionStatusSQL(String branchTable, String dbType) {
        if (DBType.MYSQL.name().equalsIgnoreCase(dbType) || DBType.OCEANBASE.name().equalsIgnoreCase(dbType) || DBType.H2.name().equalsIgnoreCase(dbType)) {
            return UPDATE_BRANCH_TRANSACTION_STATUS_MYSQL.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
        }
        if (DBType.ORACLE.name().equalsIgnoreCase(dbType)) {
            return UPDATE_BRANCH_TRANSACTION_STATUS_ORACLE.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
        }
        if (DBType.POSTGRESQL.name().equalsIgnoreCase(dbType)) {
            return UPDATE_BRANCH_TRANSACTION_STATUS_POSTGRESQL.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
        }
        throw new NotSupportYetException("unknown dbType:" + dbType);
    }

    public static String getDeleteBranchTransactionByBranchIdSQL(String branchTable, String dbType) {
        return DELETE_BRANCH_TRANSACTION_BY_BRANCH_ID.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
    }

    public static String getDeleteBranchTransactionByXId(String branchTable, String dbType) {
        return DELETE_BRANCH_TRANSACTION_BY_XID.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
    }

    public static String getQueryBranchTransaction(String branchTable, String dbType) {
        return QUERY_BRANCH_TRANSACTION.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
    }

    public static String getQueryBranchTransaction(String branchTable, String dbType, String paramsPlaceHolder) {
        return QUERY_BRANCH_TRANSACTION_XIDS.replace(BRANCH_TABLE_PLACEHOLD, branchTable).replace(PRAMETER_PLACEHOLD, paramsPlaceHolder);
    }

    public static String getQueryGlobalMax(String globalTable, String dbType) {
        return QUERY_MAX_TRANS_ID.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
    }

    public static String getQueryBranchMax(String branchTable, String dbType) {
        return QUERY_MAX_BTANCH_ID.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
    }
}

