/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.core.protocol.ResultCode;
import io.seata.core.protocol.RpcMessage;
import io.seata.core.protocol.transaction.BranchCommitRequest;
import io.seata.core.protocol.transaction.BranchCommitResponse;
import io.seata.core.protocol.transaction.BranchRollbackRequest;
import io.seata.core.protocol.transaction.BranchRollbackResponse;
import io.seata.core.protocol.transaction.UndoLogDeleteRequest;
import io.seata.core.rpc.ClientMessageListener;
import io.seata.core.rpc.ClientMessageSender;
import io.seata.core.rpc.TransactionMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmMessageListener
implements ClientMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmMessageListener.class);
    private TransactionMessageHandler handler;
    private ClientMessageSender sender;

    public RmMessageListener(TransactionMessageHandler handler, ClientMessageSender sender) {
        this.handler = handler;
        this.sender = sender;
    }

    public void setSender(ClientMessageSender sender) {
        this.sender = sender;
    }

    public ClientMessageSender getSender() {
        if (this.sender == null) {
            throw new IllegalArgumentException("clientMessageSender must not be null");
        }
        return this.sender;
    }

    public void setHandler(TransactionMessageHandler handler) {
        this.handler = handler;
    }

    @Override
    public void onMessage(RpcMessage request, String serverAddress) {
        Object msg = request.getBody();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("onMessage:" + msg);
        }
        if (msg instanceof BranchCommitRequest) {
            this.handleBranchCommit(request, serverAddress, (BranchCommitRequest)msg);
        } else if (msg instanceof BranchRollbackRequest) {
            this.handleBranchRollback(request, serverAddress, (BranchRollbackRequest)msg);
        } else if (msg instanceof UndoLogDeleteRequest) {
            this.handleUndoLogDelete((UndoLogDeleteRequest)msg);
        }
    }

    private void handleBranchRollback(RpcMessage request, String serverAddress, BranchRollbackRequest branchRollbackRequest) {
        BranchRollbackResponse resultMessage = null;
        resultMessage = (BranchRollbackResponse)this.handler.onRequest(branchRollbackRequest, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("branch rollback result:" + resultMessage);
        }
        try {
            this.sender.sendResponse(request, serverAddress, resultMessage);
        }
        catch (Throwable throwable) {
            LOGGER.error("send response error: {}", (Object)throwable.getMessage(), (Object)throwable);
        }
    }

    private void handleBranchCommit(RpcMessage request, String serverAddress, BranchCommitRequest branchCommitRequest) {
        BranchCommitResponse resultMessage = null;
        try {
            resultMessage = (BranchCommitResponse)this.handler.onRequest(branchCommitRequest, null);
            this.getSender().sendResponse(request, serverAddress, resultMessage);
        }
        catch (Exception e) {
            LOGGER.error(FrameworkErrorCode.NetOnMessage.getErrCode(), (Object)e.getMessage(), (Object)e);
            if (resultMessage == null) {
                resultMessage = new BranchCommitResponse();
            }
            resultMessage.setResultCode(ResultCode.Failed);
            resultMessage.setMsg(e.getMessage());
            this.getSender().sendResponse(request, serverAddress, resultMessage);
        }
    }

    private void handleUndoLogDelete(UndoLogDeleteRequest undoLogDeleteRequest) {
        try {
            this.handler.onRequest(undoLogDeleteRequest, null);
        }
        catch (Exception e) {
            LOGGER.error("Failed to delete undo log by undoLogDeleteRequest on" + undoLogDeleteRequest.getResourceId());
        }
    }
}

