/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.springcloud;

import io.seata.common.holder.ObjectHolder;
import io.seata.common.util.StringUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigurationChangeListener;
import java.util.Set;
import org.springframework.context.ApplicationContext;

public class SpringCloudConfiguration
extends AbstractConfiguration {
    private static final String CONFIG_TYPE = "SpringCloudConfig";
    private static volatile SpringCloudConfiguration instance;
    private static final String PREFIX = "seata.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpringCloudConfiguration getInstance() {
        if (null != instance) return instance;
        Class<SpringCloudConfiguration> clazz = SpringCloudConfiguration.class;
        synchronized (SpringCloudConfiguration.class) {
            if (null != instance) return instance;
            instance = new SpringCloudConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SpringCloudConfiguration() {
    }

    @Override
    public String getTypeName() {
        return CONFIG_TYPE;
    }

    @Override
    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        ApplicationContext applicationContext = ObjectHolder.INSTANCE.getObject(ApplicationContext.class);
        if (null == applicationContext || null == applicationContext.getEnvironment()) {
            return defaultValue;
        }
        String conf = applicationContext.getEnvironment().getProperty(PREFIX + dataId);
        return StringUtils.isNotBlank(conf) ? conf : defaultValue;
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        throw new UnsupportedOperationException();
    }
}

