/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.UndoLogManager;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataCompareUtils {
    public static boolean isFieldEquals(Field f0, Field f1) {
        if (f0 == null) {
            return f1 == null;
        }
        if (f1 == null) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase(f0.getName(), f1.getName()) && f0.getType() == f1.getType()) {
            if (f0.getValue() == null) {
                return f1.getValue() == null;
            }
            if (f1.getValue() == null) {
                return false;
            }
            String currentSerializer = UndoLogManager.getCurrentSerializer();
            if (StringUtils.equals(currentSerializer, "fastjson")) {
                DataCompareUtils.convertType(f0, f1);
            }
            return f0.getValue().equals(f1.getValue());
        }
        return false;
    }

    private static void convertType(Field f0, Field f1) {
        int f0Type = f0.getType();
        int f1Type = f1.getType();
        if (f0Type == 93 && f0.getValue().getClass().equals(String.class)) {
            f0.setValue(Timestamp.valueOf(f0.getValue().toString()));
        }
        if (f1Type == 93 && f1.getValue().getClass().equals(String.class)) {
            f1.setValue(Timestamp.valueOf(f1.getValue().toString()));
        }
        if (f0Type == 3 && f0.getValue().getClass().equals(Integer.class)) {
            f0.setValue(new BigDecimal(f0.getValue().toString()));
        }
        if (f1Type == 3 && f1.getValue().getClass().equals(Integer.class)) {
            f1.setValue(new BigDecimal(f1.getValue().toString()));
        }
    }

    public static boolean isRecordsEquals(TableRecords beforeImage, TableRecords afterImage) {
        if (beforeImage == null) {
            return afterImage == null;
        }
        if (afterImage == null) {
            return false;
        }
        if (beforeImage.getTableName().equalsIgnoreCase(afterImage.getTableName()) && CollectionUtils.isSizeEquals(beforeImage.getRows(), afterImage.getRows())) {
            return DataCompareUtils.compareRows(beforeImage.getTableMeta(), beforeImage.getRows(), afterImage.getRows());
        }
        return false;
    }

    public static boolean isRowsEquals(TableMeta tableMetaData, List<Row> oldRows, List<Row> newRows) {
        return CollectionUtils.isSizeEquals(oldRows, newRows) && DataCompareUtils.compareRows(tableMetaData, oldRows, newRows);
    }

    private static boolean compareRows(TableMeta tableMetaData, List<Row> oldRows, List<Row> newRows) {
        Map<String, Map<String, Field>> oldRowsMap = DataCompareUtils.rowListToMap(oldRows, tableMetaData.getPkName());
        Map<String, Map<String, Field>> newRowsMap = DataCompareUtils.rowListToMap(newRows, tableMetaData.getPkName());
        for (String rowKey : oldRowsMap.keySet()) {
            Map<String, Field> oldRow = oldRowsMap.get(rowKey);
            Map<String, Field> newRow = newRowsMap.get(rowKey);
            if (newRow == null) {
                return false;
            }
            for (String fieldName : oldRow.keySet()) {
                Field oldField = oldRow.get(fieldName);
                Field newField = newRow.get(fieldName);
                if (newField == null) {
                    return false;
                }
                if (DataCompareUtils.isFieldEquals(oldField, newField)) continue;
                return false;
            }
        }
        return true;
    }

    private static Map<String, Map<String, Field>> rowListToMap(List<Row> rowList, String primaryKey) {
        HashMap<String, Map<String, Field>> rowMap = new HashMap<String, Map<String, Field>>();
        for (Row row : rowList) {
            HashMap<String, Field> colsMap = new HashMap<String, Field>();
            String rowKey = null;
            for (int j = 0; j < row.getFields().size(); ++j) {
                Field field = row.getFields().get(j);
                if (field.getName().equalsIgnoreCase(primaryKey)) {
                    rowKey = String.valueOf(field.getValue());
                }
                colsMap.put(field.getName().trim().toUpperCase(), field);
            }
            rowMap.put(rowKey, colsMap);
        }
        return rowMap;
    }
}

