/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry.etcd3;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseTimeToLiveResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.LeaseOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchResponse;
import io.netty.util.CharsetUtil;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.NetUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryService;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdRegistryServiceImpl
implements RegistryService<Watch.Listener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdRegistryServiceImpl.class);
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_TYPE = "etcd3";
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String REGISTRY_CLUSTER = "cluster";
    private static final String DEFAULT_CLUSTER_NAME = "default";
    private static final String REGISTRY_KEY_PREFIX = "registry-seata-";
    private static final String FILE_CONFIG_KEY_PREFIX = "registry.etcd3.";
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static final int THREAD_POOL_SIZE = 2;
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(2, 2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("registry-etcd3", 2));
    private static final long TTL = 10L;
    private static final long LIFE_KEEP_INTERVAL = 5L;
    private static final long LIFE_KEEP_CRITICAL = 6L;
    private static volatile EtcdRegistryServiceImpl instance;
    private static volatile Client client;
    private static ConcurrentMap<String, List<InetSocketAddress>> clusterAddressMap;
    private static ConcurrentMap<String, Set<Watch.Listener>> listenerMap;
    private static ConcurrentMap<String, EtcdWatcher> watcherMap;
    private static long leaseId;
    private EtcdLifeKeeper lifeKeeper = null;
    private Future<Boolean> lifeKeeperFuture = null;
    public static final String TEST_ENDPONT = "etcd-test-lancher-endpoint";

    private EtcdRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static EtcdRegistryServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<EtcdRegistryServiceImpl> clazz = EtcdRegistryServiceImpl.class;
        synchronized (EtcdRegistryServiceImpl.class) {
            if (null != instance) return instance;
            clusterAddressMap = new ConcurrentHashMap<String, List<InetSocketAddress>>(8);
            listenerMap = new ConcurrentHashMap<String, Set<Watch.Listener>>(8);
            watcherMap = new ConcurrentHashMap<String, EtcdWatcher>(8);
            instance = new EtcdRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress(address);
        this.doRegister(address);
    }

    private void doRegister(InetSocketAddress address) throws Exception {
        PutOption putOption = PutOption.newBuilder().withLeaseId(this.getLeaseId()).build();
        this.getClient().getKVClient().put(this.buildRegestryKey(address), this.buildRegistryValue(address), putOption).get();
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
        NetUtil.validAddress(address);
        this.doUnregister(address);
    }

    private void doUnregister(InetSocketAddress address) throws Exception {
        this.getClient().getKVClient().delete(this.buildRegestryKey(address)).get();
    }

    @Override
    public void subscribe(String cluster, Watch.Listener listener) throws Exception {
        listenerMap.putIfAbsent(cluster, new HashSet());
        ((Set)listenerMap.get(cluster)).add(listener);
        EtcdWatcher watcher = watcherMap.computeIfAbsent(cluster, w -> new EtcdWatcher(listener));
        EXECUTOR_SERVICE.submit(watcher);
    }

    @Override
    public void unsubscribe(String cluster, Watch.Listener listener) throws Exception {
        Set subscribeSet = (Set)listenerMap.get(cluster);
        if (null != subscribeSet) {
            HashSet<Watch.Listener> newSubscribeSet = new HashSet<Watch.Listener>();
            for (Watch.Listener eventListener : subscribeSet) {
                if (eventListener.equals(listener)) continue;
                newSubscribeSet.add(eventListener);
            }
            listenerMap.put(cluster, newSubscribeSet);
        }
        ((EtcdWatcher)watcherMap.remove(cluster)).stop();
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        final String cluster = this.getServiceGroup(key);
        if (null == cluster) {
            return null;
        }
        if (!listenerMap.containsKey(cluster)) {
            this.refreshCluster(cluster);
            this.subscribe(cluster, new Watch.Listener(){

                public void onNext(WatchResponse response) {
                    try {
                        EtcdRegistryServiceImpl.this.refreshCluster(cluster);
                    }
                    catch (Exception e) {
                        LOGGER.error("etcd watch listener", (Throwable)e);
                        throw new RuntimeException(e.getMessage());
                    }
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            });
        }
        return (List)clusterAddressMap.get(cluster);
    }

    @Override
    public void close() throws Exception {
        if (null != this.lifeKeeper) {
            this.lifeKeeper.stop();
            if (null != this.lifeKeeperFuture) {
                this.lifeKeeperFuture.get(3L, TimeUnit.SECONDS);
            }
        }
    }

    private void refreshCluster(String cluster) throws Exception {
        if (null == cluster) {
            return;
        }
        GetOption getOption = GetOption.newBuilder().withPrefix(this.buildRegestryKeyPrefix()).build();
        GetResponse getResponse = (GetResponse)this.getClient().getKVClient().get(this.buildRegestryKeyPrefix(), getOption).get();
        List instanceList = getResponse.getKvs().stream().map(keyValue -> {
            String[] instanceInfo = keyValue.getValue().toString(CharsetUtil.UTF_8).split(":");
            return new InetSocketAddress(instanceInfo[0], Integer.parseInt(instanceInfo[1]));
        }).collect(Collectors.toList());
        clusterAddressMap.put(cluster, instanceList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Client getClient() {
        if (null != client) return client;
        Class<EtcdRegistryServiceImpl> clazz = EtcdRegistryServiceImpl.class;
        synchronized (EtcdRegistryServiceImpl.class) {
            if (null != client) return client;
            String testEndpoint = System.getProperty(TEST_ENDPONT);
            client = StringUtils.isNotBlank(testEndpoint) ? Client.builder().endpoints(new String[]{testEndpoint}).build() : Client.builder().endpoints(new String[]{FILE_CONFIG.getConfig("registry.etcd3.serverAddr")}).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return client;
        }
    }

    private String getServiceGroup(String key) {
        String clusterNameKey = "service.vgroup_mapping." + key;
        return ConfigurationFactory.getInstance().getConfig(clusterNameKey);
    }

    private String getClusterName() {
        String clusterConfigName = "registry.etcd3.cluster";
        return FILE_CONFIG.getConfig(clusterConfigName, DEFAULT_CLUSTER_NAME);
    }

    private long getLeaseId() throws Exception {
        if (0L == leaseId) {
            leaseId = ((LeaseGrantResponse)this.getClient().getLeaseClient().grant(10L).get()).getID();
            this.lifeKeeper = new EtcdLifeKeeper(leaseId);
            this.lifeKeeperFuture = EXECUTOR_SERVICE.submit(this.lifeKeeper);
        }
        return leaseId;
    }

    private ByteSequence buildRegestryKey(InetSocketAddress address) {
        return ByteSequence.from((String)(REGISTRY_KEY_PREFIX + this.getClusterName() + "-" + NetUtil.toStringAddress(address)), (Charset)CharsetUtil.UTF_8);
    }

    private ByteSequence buildRegestryKeyPrefix() {
        return ByteSequence.from((String)(REGISTRY_KEY_PREFIX + this.getClusterName()), (Charset)CharsetUtil.UTF_8);
    }

    private ByteSequence buildRegistryValue(InetSocketAddress address) {
        return ByteSequence.from((String)NetUtil.toStringAddress(address), (Charset)CharsetUtil.UTF_8);
    }

    static {
        clusterAddressMap = null;
        listenerMap = null;
        watcherMap = null;
        leaseId = 0L;
    }

    private class EtcdWatcher
    implements Runnable {
        private final Watch.Listener listener;
        private Watch.Watcher watcher;

        public EtcdWatcher(Watch.Listener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            Watch watchClient = EtcdRegistryServiceImpl.this.getClient().getWatchClient();
            WatchOption watchOption = WatchOption.newBuilder().withPrefix(EtcdRegistryServiceImpl.this.buildRegestryKeyPrefix()).build();
            this.watcher = watchClient.watch(EtcdRegistryServiceImpl.this.buildRegestryKeyPrefix(), watchOption, this.listener);
        }

        public void stop() {
            this.watcher.close();
        }
    }

    private class EtcdLifeKeeper
    implements Callable<Boolean> {
        private final long leaseId;
        private final Lease leaseClient;
        private boolean running;

        public EtcdLifeKeeper(long leaseId) {
            this.leaseClient = EtcdRegistryServiceImpl.this.getClient().getLeaseClient();
            this.leaseId = leaseId;
            this.running = true;
        }

        private void process() {
            try {
                while (true) {
                    LeaseTimeToLiveResponse leaseTimeToLiveResponse;
                    long tTl;
                    if ((tTl = (leaseTimeToLiveResponse = (LeaseTimeToLiveResponse)this.leaseClient.timeToLive(this.leaseId, LeaseOption.DEFAULT).get()).getTTl()) <= 6L) {
                        this.leaseClient.keepAliveOnce(this.leaseId).get();
                    }
                    TimeUnit.SECONDS.sleep(5L);
                }
            }
            catch (Exception e) {
                LOGGER.error("EtcdLifeKeeper", (Throwable)e);
                throw new ShouldNeverHappenException("failed to renewal the lease.");
            }
        }

        public void stop() {
            this.running = false;
        }

        @Override
        public Boolean call() {
            if (this.running) {
                this.process();
            }
            return this.running;
        }
    }
}

