/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.model;

import java.util.HashMap;
import java.util.Map;

public enum GlobalStatus {
    UnKnown(0),
    Begin(1),
    Committing(2),
    CommitRetrying(3),
    Rollbacking(4),
    RollbackRetrying(5),
    TimeoutRollbacking(6),
    TimeoutRollbackRetrying(7),
    AsyncCommitting(8),
    Committed(9),
    CommitFailed(10),
    Rollbacked(11),
    RollbackFailed(12),
    TimeoutRollbacked(13),
    TimeoutRollbackFailed(14),
    Finished(15);

    private int code;
    private static final Map<Integer, GlobalStatus> MAP;

    private GlobalStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static GlobalStatus get(byte code) {
        return GlobalStatus.get((int)code);
    }

    public static GlobalStatus get(int code) {
        GlobalStatus status = MAP.get(code);
        if (null == status) {
            throw new IllegalArgumentException("Unknown GlobalStatus[" + code + "]");
        }
        return status;
    }

    static {
        MAP = new HashMap<Integer, GlobalStatus>(GlobalStatus.values().length);
        for (GlobalStatus status : GlobalStatus.values()) {
            MAP.put(status.code, status);
        }
    }
}

