/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.zk;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.StringUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConfiguration
extends AbstractConfiguration<IZkDataListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfiguration.class);
    private static final String REGISTRY_TYPE = "zk";
    private static final String ZK_PATH_SPLIT_CHAR = "/";
    private static final String FILE_ROOT_CONFIG = "config";
    private static final String ROOT_PATH = "/config";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String SESSION_TIMEOUT_KEY = "session.timeout";
    private static final String CONNECT_TIMEOUT_KEY = "connect.timeout";
    private static final int THREAD_POOL_NUM = 1;
    private static final int DEFAULT_SESSION_TIMEOUT = 6000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final String FILE_CONFIG_KEY_PREFIX = "config.zk.";
    private static final ExecutorService CONFIG_EXECUTOR = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("ZKConfigThread", 1));
    private static volatile ZkClient zkClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZookeeperConfiguration() {
        if (zkClient != null) return;
        Class<ZookeeperConfiguration> clazz = ZookeeperConfiguration.class;
        synchronized (ZookeeperConfiguration.class) {
            if (null == zkClient) {
                zkClient = new ZkClient(FILE_CONFIG.getConfig("config.zk.serverAddr"), FILE_CONFIG.getInt("config.zk.session.timeout", 6000), FILE_CONFIG.getInt("config.zk.connect.timeout", 2000));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (zkClient.exists(ROOT_PATH)) return;
            zkClient.createPersistent(ROOT_PATH, true);
            return;
        }
    }

    @Override
    public String getTypeName() {
        return REGISTRY_TYPE;
    }

    @Override
    public String getConfig(final String dataId, final String defaultValue, long timeoutMills) {
        FutureTask<String> future = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String path = "/config/" + dataId;
                String value = (String)zkClient.readData(path);
                if (StringUtils.isNullOrEmpty(value)) {
                    return defaultValue;
                }
                return value;
            }
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("getConfig {} is error or timeout,return defaultValue {}", (Object)dataId, (Object)defaultValue);
            return defaultValue;
        }
    }

    @Override
    public boolean putConfig(final String dataId, final String content, long timeoutMills) {
        FutureTask<Boolean> future = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String path = "/config/" + dataId;
                if (!zkClient.exists(path)) {
                    zkClient.create(path, (Object)content, CreateMode.PERSISTENT);
                } else {
                    zkClient.writeData(path, (Object)content);
                }
                return true;
            }
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("putConfig {} : {} is error or timeout", (Object)dataId, (Object)content);
            return false;
        }
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    @Override
    public boolean removeConfig(final String dataId, long timeoutMills) {
        FutureTask<Boolean> future = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String path = "/config/" + dataId;
                return zkClient.delete(path);
            }
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("removeConfig {} is error or timeout", (Object)dataId);
            return false;
        }
    }

    @Override
    public void addConfigListener(String dataId, IZkDataListener listener) {
        String path = "/config/" + dataId;
        if (zkClient.exists(path)) {
            zkClient.subscribeDataChanges(path, listener);
        }
    }

    @Override
    public void removeConfigListener(String dataId, IZkDataListener listener) {
        String path = "/config/" + dataId;
        if (zkClient.exists(path)) {
            zkClient.unsubscribeDataChanges(path, listener);
        }
    }

    @Override
    public List<IZkDataListener> getConfigListeners(String dataId) {
        throw new NotSupportYetException("not support getConfigListeners");
    }
}

