/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.etcd3;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.kv.TxnResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.watch.WatchResponse;
import io.netty.util.CharsetUtil;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.CollectionUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigChangeListener;
import io.seata.config.ConfigFuture;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdConfiguration
extends AbstractConfiguration<ConfigChangeListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdConfiguration.class);
    private static volatile EtcdConfiguration instance;
    private static volatile Client client;
    private static final Configuration FILE_CONFIG;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String CONFIG_TYPE = "etcd3";
    private static final String FILE_CONFIG_KEY_PREFIX = "config.etcd3.";
    private static final int THREAD_POOL_NUM = 1;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static ExecutorService etcdConfigExecutor;
    private static ExecutorService etcdNotifierExecutor;
    private static ConcurrentMap<String, List<ConfigChangeListener>> configListenersMap;
    private static ConcurrentHashMap<String, List<ConfigChangeNotifier>> configChangeNotifiersMap;
    private static final long VERSION_NOT_EXIST = 0L;

    private EtcdConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EtcdConfiguration getInstance() {
        if (null != instance) return instance;
        Class<EtcdConfiguration> clazz = EtcdConfiguration.class;
        synchronized (EtcdConfiguration.class) {
            if (null != instance) return instance;
            etcdConfigExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("etcd-config-executor", 1));
            etcdNotifierExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("etcd-config-notifier-executor", 1));
            configListenersMap = new ConcurrentHashMap<String, List<ConfigChangeListener>>(8);
            configChangeNotifiersMap = new ConcurrentHashMap(8);
            instance = new EtcdConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getTypeName() {
        return CONFIG_TYPE;
    }

    @Override
    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        etcdConfigExecutor.execute(() -> this.complete(EtcdConfiguration.getClient().getKVClient().get(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8)), configFuture));
        return (String)configFuture.get();
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUT, timeoutMills);
        etcdConfigExecutor.execute(() -> this.complete(EtcdConfiguration.getClient().getKVClient().put(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8), ByteSequence.from((String)content, (Charset)CharsetUtil.UTF_8)), configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUTIFABSENT, timeoutMills);
        etcdConfigExecutor.execute(() -> this.complete(client.getKVClient().txn().If(new Cmp[]{new Cmp(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8), Cmp.Op.EQUAL, (CmpTarget)CmpTarget.version((long)0L))}).Then(new Op[]{Op.put((ByteSequence)ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8), (ByteSequence)ByteSequence.from((String)content, (Charset)CharsetUtil.UTF_8), (PutOption)PutOption.DEFAULT)}).commit(), configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, null, ConfigFuture.ConfigOperation.REMOVE, timeoutMills);
        etcdConfigExecutor.execute(() -> this.complete(EtcdConfiguration.getClient().getKVClient().delete(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8)), configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public void addConfigListener(String dataId, ConfigChangeListener listener) {
        configListenersMap.putIfAbsent(dataId, new ArrayList());
        configChangeNotifiersMap.putIfAbsent(dataId, new ArrayList());
        ConfigChangeNotifier configChangeNotifier = new ConfigChangeNotifier(dataId, listener);
        configChangeNotifiersMap.get(dataId).add(configChangeNotifier);
        if (null != listener.getExecutor()) {
            listener.getExecutor().submit(configChangeNotifier);
        } else {
            etcdNotifierExecutor.submit(configChangeNotifier);
        }
    }

    @Override
    public void removeConfigListener(String dataId, ConfigChangeListener listener) {
        List configChangeListeners = this.getConfigListeners(dataId);
        if (configChangeListeners == null) {
            return;
        }
        ArrayList<ConfigChangeListener> newChangeListenerList = new ArrayList<ConfigChangeListener>();
        for (ConfigChangeListener changeListener : configChangeListeners) {
            if (changeListener.equals(listener)) continue;
            newChangeListenerList.add(changeListener);
        }
        configListenersMap.put(dataId, newChangeListenerList);
        if (null != listener.getExecutor()) {
            listener.getExecutor().shutdownNow();
        }
        List<ConfigChangeNotifier> configChangeNotifiers = configChangeNotifiersMap.get(dataId);
        ArrayList<ConfigChangeNotifier> newConfigChangeNotifiers = new ArrayList<ConfigChangeNotifier>();
        for (ConfigChangeNotifier configChangeNotifier : configChangeNotifiers) {
            if (!listener.equals(configChangeNotifier.getListener())) {
                newConfigChangeNotifiers.add(configChangeNotifier);
                continue;
            }
            configChangeNotifier.stop();
        }
        configChangeNotifiersMap.put(dataId, newConfigChangeNotifiers);
    }

    @Override
    public List getConfigListeners(String dataId) {
        return (List)configListenersMap.get(dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Client getClient() {
        if (null != client) return client;
        Class<EtcdConfiguration> clazz = EtcdConfiguration.class;
        synchronized (EtcdConfiguration.class) {
            if (null != client) return client;
            client = Client.builder().endpoints(new String[]{FILE_CONFIG.getConfig("config.etcd3.serverAddr")}).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private <T> void complete(CompletableFuture<T> completableFuture, ConfigFuture configFuture) {
        block8: {
            try {
                T response = completableFuture.get();
                if (response instanceof GetResponse) {
                    ByteSequence value;
                    List keyValues = ((GetResponse)response).getKvs();
                    if (CollectionUtils.isNotEmpty(keyValues) && null != (value = ((KeyValue)keyValues.get(0)).getValue())) {
                        configFuture.setResult(value.toString(CharsetUtil.UTF_8));
                    }
                    break block8;
                }
                if (response instanceof PutResponse) {
                    configFuture.setResult(Boolean.TRUE);
                    break block8;
                }
                if (response instanceof TxnResponse) {
                    boolean result = ((TxnResponse)response).isSucceeded();
                    if (result) {
                        configFuture.setResult(Boolean.TRUE);
                    }
                    break block8;
                }
                if (response instanceof DeleteResponse) {
                    configFuture.setResult(Boolean.TRUE);
                    break block8;
                }
                throw new ShouldNeverHappenException("unsupported response type");
            }
            catch (Exception e) {
                LOGGER.error("error occurred while completing the future{}", (Object)e.getMessage());
            }
        }
    }

    static {
        FILE_CONFIG = ConfigurationFactory.getInstance();
        etcdConfigExecutor = null;
        etcdNotifierExecutor = null;
        configListenersMap = null;
        configChangeNotifiersMap = null;
    }

    private static class ConfigChangeNotifier
    implements Runnable {
        private final String dataId;
        private final ConfigChangeListener listener;
        private Watch.Watcher watcher;

        ConfigChangeNotifier(String dataId, ConfigChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
        }

        ConfigChangeListener getListener() {
            return this.listener;
        }

        @Override
        public void run() {
            Watch watchClient = EtcdConfiguration.getClient().getWatchClient();
            this.watcher = watchClient.watch(ByteSequence.from((String)this.dataId, (Charset)CharsetUtil.UTF_8), new Watch.Listener(){

                public void onNext(WatchResponse response) {
                    this.notifyListeners();
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            });
        }

        private void notifyListeners() {
            try {
                GetResponse getResponse = (GetResponse)EtcdConfiguration.getClient().getKVClient().get(ByteSequence.from((String)this.dataId, (Charset)CharsetUtil.UTF_8)).get();
                List keyValues = getResponse.getKvs();
                if (CollectionUtils.isNotEmpty(keyValues)) {
                    for (ConfigChangeListener listener : (List)configListenersMap.get(this.dataId)) {
                        listener.receiveConfigInfo(((KeyValue)keyValues.get(0)).getValue().toString(CharsetUtil.UTF_8));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("error occurred while getting value{}", (Object)e.getMessage());
            }
        }

        public void stop() {
            this.watcher.close();
        }
    }
}

