/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.util;

import io.seata.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CollectionUtils {
    private static final String KV_SPLIT = "=";
    private static final String PAIR_SPLIT = "&";

    public static boolean isEmpty(Collection col) {
        return !CollectionUtils.isNotEmpty(col);
    }

    public static boolean isNotEmpty(Collection col) {
        return col != null && col.size() > 0;
    }

    public static boolean isEmpty(Object[] array) {
        return !CollectionUtils.isNotEmpty(array);
    }

    public static boolean isNotEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    public static String toString(Collection col) {
        if (CollectionUtils.isEmpty(col)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (Object obj : col) {
            sb.append(StringUtils.toString(obj));
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    public static boolean isSizeEquals(Collection col0, Collection col1) {
        if (col0 == null) {
            return col1 == null;
        }
        if (col1 == null) {
            return false;
        }
        return col0.size() == col1.size();
    }

    public static String encodeMap(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(KV_SPLIT).append(entry.getValue()).append(PAIR_SPLIT);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static Map<String, String> decodeMap(String data) {
        if (data == null) {
            return null;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        if (StringUtils.isBlank(data)) {
            return map;
        }
        String[] kvPairs = data.split(PAIR_SPLIT);
        if (kvPairs.length == 0) {
            return map;
        }
        for (String kvPair : kvPairs) {
            String[] kvs;
            if (StringUtils.isNullOrEmpty(kvPair) || (kvs = kvPair.split(KV_SPLIT)).length != 2) continue;
            map.put(kvs[0], kvs[1]);
        }
        return map;
    }

    public static List<String> toUpperList(List<String> sourceList) {
        if (null == sourceList || sourceList.size() == 0) {
            return sourceList;
        }
        ArrayList<String> destList = new ArrayList<String>(sourceList.size());
        for (String element : sourceList) {
            if (null != element) {
                destList.add(element.toUpperCase());
                continue;
            }
            destList.add(element);
        }
        return destList;
    }
}

