/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.seata.protocol.transaction;

import io.seata.codec.seata.protocol.transaction.AbstractTransactionRequestToTCCodec;
import io.seata.core.protocol.transaction.GlobalBeginRequest;
import java.nio.ByteBuffer;

public class GlobalBeginRequestCodec
extends AbstractTransactionRequestToTCCodec {
    @Override
    public Class<?> getMessageClassType() {
        return GlobalBeginRequest.class;
    }

    @Override
    public <T> void encode(T t, ByteBuffer out) {
        GlobalBeginRequest globalBeginRequest = (GlobalBeginRequest)t;
        int timeout = globalBeginRequest.getTimeout();
        String transactionName = globalBeginRequest.getTransactionName();
        out.putInt(timeout);
        if (transactionName != null) {
            byte[] bs = transactionName.getBytes(UTF8);
            out.putShort((short)bs.length);
            if (bs.length > 0) {
                out.put(bs);
            }
        } else {
            out.putShort((short)0);
        }
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        GlobalBeginRequest globalBeginRequest = (GlobalBeginRequest)t;
        globalBeginRequest.setTimeout(in.getInt());
        short len = in.getShort();
        if (len > 0) {
            byte[] bs = new byte[len];
            in.get(bs);
            globalBeginRequest.setTransactionName(new String(bs, UTF8));
        }
    }
}

