/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.fuseable.FuseToFlowable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableSequenceEqual;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public final class FlowableSequenceEqualSingle<T>
extends Single<Boolean>
implements FuseToFlowable<Boolean> {
    final Publisher<? extends T> first;
    final Publisher<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int prefetch;

    public FlowableSequenceEqualSingle(Publisher<? extends T> first, Publisher<? extends T> second, BiPredicate<? super T, ? super T> comparer, int prefetch) {
        this.first = first;
        this.second = second;
        this.comparer = comparer;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(SingleObserver<? super Boolean> s) {
        EqualCoordinator<? extends T> parent = new EqualCoordinator<T>(s, this.prefetch, this.comparer);
        s.onSubscribe(parent);
        parent.subscribe(this.first, this.second);
    }

    @Override
    public Flowable<Boolean> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableSequenceEqual<T>(this.first, this.second, this.comparer, this.prefetch));
    }

    static final class EqualCoordinator<T>
    extends AtomicInteger
    implements Disposable,
    FlowableSequenceEqual.EqualCoordinatorHelper {
        private static final long serialVersionUID = -6178010334400373240L;
        final SingleObserver<? super Boolean> actual;
        final BiPredicate<? super T, ? super T> comparer;
        final FlowableSequenceEqual.EqualSubscriber<T> first;
        final FlowableSequenceEqual.EqualSubscriber<T> second;
        final AtomicThrowable error;
        T v1;
        T v2;

        EqualCoordinator(SingleObserver<? super Boolean> actual, int prefetch, BiPredicate<? super T, ? super T> comparer) {
            this.actual = actual;
            this.comparer = comparer;
            this.first = new FlowableSequenceEqual.EqualSubscriber(this, prefetch);
            this.second = new FlowableSequenceEqual.EqualSubscriber(this, prefetch);
            this.error = new AtomicThrowable();
        }

        void subscribe(Publisher<? extends T> source1, Publisher<? extends T> source2) {
            source1.subscribe(this.first);
            source2.subscribe(this.second);
        }

        @Override
        public void dispose() {
            this.first.cancel();
            this.second.cancel();
            if (this.getAndIncrement() == 0) {
                this.first.clear();
                this.second.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return SubscriptionHelper.isCancelled((Subscription)this.first.get());
        }

        void cancelAndClear() {
            this.first.cancel();
            this.first.clear();
            this.second.cancel();
            this.second.clear();
        }

        @Override
        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            block6: do {
                Throwable ex;
                SimpleQueue q1 = this.first.queue;
                SimpleQueue q2 = this.second.queue;
                if (q1 != null && q2 != null) {
                    while (true) {
                        boolean c;
                        boolean e2;
                        if (this.isDisposed()) {
                            this.first.clear();
                            this.second.clear();
                            return;
                        }
                        ex = (Throwable)this.error.get();
                        if (ex != null) {
                            this.cancelAndClear();
                            this.actual.onError(this.error.terminate());
                            return;
                        }
                        boolean d1 = this.first.done;
                        T a = this.v1;
                        if (a == null) {
                            try {
                                a = q1.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                this.cancelAndClear();
                                this.error.addThrowable(exc);
                                this.actual.onError(this.error.terminate());
                                return;
                            }
                            this.v1 = a;
                        }
                        boolean e1 = a == null;
                        boolean d2 = this.second.done;
                        T b = this.v2;
                        if (b == null) {
                            try {
                                b = q2.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                this.cancelAndClear();
                                this.error.addThrowable(exc);
                                this.actual.onError(this.error.terminate());
                                return;
                            }
                            this.v2 = b;
                        }
                        boolean bl = e2 = b == null;
                        if (d1 && d2 && e1 && e2) {
                            this.actual.onSuccess((Boolean)true);
                            return;
                        }
                        if (d1 && d2 && e1 != e2) {
                            this.cancelAndClear();
                            this.actual.onSuccess((Boolean)false);
                            return;
                        }
                        if (e1 || e2) continue block6;
                        try {
                            c = this.comparer.test(a, b);
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancelAndClear();
                            this.error.addThrowable(exc);
                            this.actual.onError(this.error.terminate());
                            return;
                        }
                        if (!c) {
                            this.cancelAndClear();
                            this.actual.onSuccess((Boolean)false);
                            return;
                        }
                        this.v1 = null;
                        this.v2 = null;
                        this.first.request();
                        this.second.request();
                    }
                }
                if (this.isDisposed()) {
                    this.first.clear();
                    this.second.clear();
                    return;
                }
                ex = (Throwable)this.error.get();
                if (ex == null) continue;
                this.cancelAndClear();
                this.actual.onError(this.error.terminate());
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        public void innerError(Throwable t) {
            if (this.error.addThrowable(t)) {
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }
    }
}

