/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Notification;
import rx.Observer;

public class TestObserver<T>
implements Observer<T> {
    private final Observer<T> delegate;
    private final ArrayList<T> onNextEvents = new ArrayList();
    private final ArrayList<Throwable> onErrorEvents = new ArrayList();
    private final ArrayList<Notification<T>> onCompletedEvents = new ArrayList();
    private static Observer<Object> INERT = new Observer<Object>(){

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onNext(Object t) {
        }
    };

    public TestObserver(Observer<T> delegate) {
        this.delegate = delegate;
    }

    public TestObserver() {
        this.delegate = INERT;
    }

    @Override
    public void onCompleted() {
        this.onCompletedEvents.add(Notification.createOnCompleted());
        this.delegate.onCompleted();
    }

    public List<Notification<T>> getOnCompletedEvents() {
        return Collections.unmodifiableList(this.onCompletedEvents);
    }

    @Override
    public void onError(Throwable e) {
        this.onErrorEvents.add(e);
        this.delegate.onError(e);
    }

    public List<Throwable> getOnErrorEvents() {
        return Collections.unmodifiableList(this.onErrorEvents);
    }

    @Override
    public void onNext(T t) {
        this.onNextEvents.add(t);
        this.delegate.onNext(t);
    }

    public List<T> getOnNextEvents() {
        return Collections.unmodifiableList(this.onNextEvents);
    }

    public List<Object> getEvents() {
        ArrayList<ArrayList<Object>> events = new ArrayList<ArrayList<Object>>();
        events.add(this.onNextEvents);
        events.add(this.onErrorEvents);
        events.add(this.onCompletedEvents);
        return Collections.unmodifiableList(events);
    }

    public void assertReceivedOnNext(List<T> items) {
        if (this.onNextEvents.size() != items.size()) {
            throw new AssertionError((Object)("Number of items does not match. Provided: " + items.size() + "  Actual: " + this.onNextEvents.size() + ".\n" + "Provided values: " + items + "\n" + "Actual values: " + this.onNextEvents));
        }
        for (int i = 0; i < items.size(); ++i) {
            T expected = items.get(i);
            T actual = this.onNextEvents.get(i);
            if (expected == null) {
                if (actual != null) {
                    throw new AssertionError((Object)("Value at index: " + i + " expected to be [null] but was: [" + actual + "]"));
                }
                continue;
            }
            if (!expected.equals(actual)) {
                throw new AssertionError((Object)("Value at index: " + i + " expected to be [" + expected + "] (" + expected.getClass().getSimpleName() + ") but was: [" + actual + "] (" + (actual != null ? actual.getClass().getSimpleName() : "null") + ")"));
            }
        }
    }

    public void assertTerminalEvent() {
        if (this.onErrorEvents.size() > 1) {
            throw new AssertionError((Object)("Too many onError events: " + this.onErrorEvents.size()));
        }
        if (this.onCompletedEvents.size() > 1) {
            throw new AssertionError((Object)("Too many onCompleted events: " + this.onCompletedEvents.size()));
        }
        if (this.onCompletedEvents.size() == 1 && this.onErrorEvents.size() == 1) {
            throw new AssertionError((Object)"Received both an onError and onCompleted. Should be one or the other.");
        }
        if (this.onCompletedEvents.size() == 0 && this.onErrorEvents.size() == 0) {
            throw new AssertionError((Object)"No terminal events received.");
        }
    }
}

