/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import rx.Subscription;
import rx.exceptions.Exceptions;

public final class SubscriptionList
implements Subscription {
    private List<Subscription> subscriptions;
    private volatile boolean unsubscribed;

    public SubscriptionList() {
    }

    public SubscriptionList(Subscription ... subscriptions) {
        this.subscriptions = new LinkedList<Subscription>(Arrays.asList(subscriptions));
    }

    @Override
    public boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Subscription s) {
        if (!this.unsubscribed) {
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                if (!this.unsubscribed) {
                    if (this.subscriptions == null) {
                        this.subscriptions = new LinkedList<Subscription>();
                    }
                    this.subscriptions.add(s);
                    return;
                }
            }
        }
        s.unsubscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() {
        if (!this.unsubscribed) {
            List<Subscription> list;
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                if (this.unsubscribed) {
                    return;
                }
                this.unsubscribed = true;
                list = this.subscriptions;
                this.subscriptions = null;
            }
            SubscriptionList.unsubscribeFromAll(list);
        }
    }

    private static void unsubscribeFromAll(Collection<Subscription> subscriptions) {
        if (subscriptions == null) {
            return;
        }
        ArrayList<Throwable> es = null;
        for (Subscription s : subscriptions) {
            try {
                s.unsubscribe();
            }
            catch (Throwable e) {
                if (es == null) {
                    es = new ArrayList<Throwable>();
                }
                es.add(e);
            }
        }
        Exceptions.throwIfAny(es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.unsubscribed) {
            List<Subscription> list;
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                list = this.subscriptions;
                this.subscriptions = null;
            }
            SubscriptionList.unsubscribeFromAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscriptions() {
        if (!this.unsubscribed) {
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                return !this.unsubscribed && this.subscriptions != null && !this.subscriptions.isEmpty();
            }
        }
        return false;
    }
}

