/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.test.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;

public final class MockStatement
implements Statement {
    private final List<Map<Object, Object>> bindings = new ArrayList<Map<Object, Object>>();
    private final Flux<Result> results;
    private boolean addCalled = false;
    private Map<Object, Object> current;
    private String[] generatedValuesColumns;

    private MockStatement(Flux<Result> results) {
        this.results = Assert.requireNonNull(results, "results must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockStatement empty() {
        return MockStatement.builder().build();
    }

    public MockStatement add() {
        this.addCalled = true;
        this.current = null;
        return this;
    }

    public Statement bind(String name, Object value) {
        Assert.requireNonNull(name, "name must not be null");
        Assert.requireNonNull(value, "value must not be null");
        this.getCurrent().put(name, value);
        return this;
    }

    public MockStatement bind(int index, Object value) {
        Assert.requireNonNull(value, "value must not be null");
        this.getCurrent().put(index, value);
        return this;
    }

    public Statement bindNull(String name, Class<?> type) {
        Assert.requireNonNull(name, "name must not be null");
        Assert.requireNonNull(type, "value must not be null");
        this.getCurrent().put(name, type);
        return this;
    }

    public MockStatement bindNull(int index, Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        this.getCurrent().put(index, type);
        return this;
    }

    public Flux<Result> execute() {
        return this.results;
    }

    public List<Map<Object, Object>> getBindings() {
        return this.bindings;
    }

    public String[] getGeneratedValuesColumns() {
        return this.generatedValuesColumns;
    }

    public boolean isAddCalled() {
        return this.addCalled;
    }

    public Statement returnGeneratedValues(String ... columns) {
        this.generatedValuesColumns = columns;
        return this;
    }

    public String toString() {
        return "MockStatement{bindings=" + this.bindings + ", results=" + this.results + ", addCalled=" + this.addCalled + ", current=" + this.current + ", generatedValuesColumns=" + Arrays.toString(this.generatedValuesColumns) + '}';
    }

    private Map<Object, Object> getCurrent() {
        if (this.current == null) {
            this.current = new HashMap<Object, Object>();
            this.bindings.add(this.current);
        }
        return this.current;
    }

    public static final class Builder {
        private final List<Result> results = new ArrayList<Result>();

        private Builder() {
        }

        public MockStatement build() {
            return new MockStatement(Flux.fromIterable(this.results));
        }

        public Builder result(Result result) {
            Assert.requireNonNull(result, "result must not be null");
            this.results.add(result);
            return this;
        }

        public String toString() {
            return "Builder{results=" + this.results + '}';
        }
    }
}

