/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.test.Assert;
import io.r2dbc.spi.test.MockConnectionFactoryMetadata;
import io.r2dbc.spi.test.Nullable;
import reactor.core.publisher.Mono;

public final class MockConnectionFactory
implements ConnectionFactory {
    private final Mono<Connection> connection;

    private MockConnectionFactory(@Nullable Mono<Connection> connection) {
        this.connection = connection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockConnectionFactory empty() {
        return MockConnectionFactory.builder().build();
    }

    public Mono<Connection> create() {
        if (this.connection == null) {
            throw new AssertionError((Object)"Unexpected call to create()");
        }
        return this.connection;
    }

    public MockConnectionFactoryMetadata getMetadata() {
        return MockConnectionFactoryMetadata.INSTANCE;
    }

    public String toString() {
        return "MockConnectionFactory{connection=" + this.connection + '}';
    }

    public static final class Builder {
        private Connection connection;

        private Builder() {
        }

        public MockConnectionFactory build() {
            return new MockConnectionFactory(this.connection == null ? null : Mono.just((Object)this.connection));
        }

        public Builder connection(Connection connection) {
            this.connection = Assert.requireNonNull(connection, "connection must not be null");
            return this;
        }

        public String toString() {
            return "Builder{connection=" + this.connection + '}';
        }
    }
}

