/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import java.util.Objects;

public class HttpCredentialTransport {
    private final Type transportType;
    private final String typeTarget;

    public HttpCredentialTransport(Type transportType, String typeTarget) {
        this.transportType = Objects.requireNonNull(transportType);
        this.typeTarget = Objects.requireNonNull(typeTarget).toLowerCase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpCredentialTransport that = (HttpCredentialTransport)o;
        if (this.transportType != that.transportType) {
            return false;
        }
        return this.typeTarget != null ? this.typeTarget.equals(that.typeTarget) : that.typeTarget == null;
    }

    public int hashCode() {
        int result = this.transportType != null ? this.transportType.hashCode() : 0;
        result = 31 * result + (this.typeTarget != null ? this.typeTarget.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HttpCredentialTransport{transportType=" + (Object)((Object)this.transportType) + ", typeTarget='" + this.typeTarget + '\'' + '}';
    }

    public static enum Type {
        COOKIE,
        AUTHORIZATION,
        OTHER_HEADER,
        POST,
        X509;

    }
}

