/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.opentracing.runtime;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Priority;

@Priority(value=3595)
public class TracingConfigRelocateConfigSourceInterceptor
extends RelocateConfigSourceInterceptor {
    private static final Map<String, String> RELOCATIONS = TracingConfigRelocateConfigSourceInterceptor.relocations();

    public TracingConfigRelocateConfigSourceInterceptor() {
        super(RELOCATIONS);
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = (String)namesIterator.next();
            names.add(name);
            String mappedName = RELOCATIONS.get(name);
            if (mappedName == null) continue;
            names.add(mappedName);
        }
        return names.iterator();
    }

    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        return context.iterateValues();
    }

    private static Map<String, String> relocations() {
        HashMap<String, String> relocations = new HashMap<String, String>();
        relocations.put("mp.opentracing.server.skip-pattern", "quarkus.opentracing.server.skip-pattern");
        relocations.put("quarkus.opentracing.server.skip-pattern", "mp.opentracing.server.skip-pattern");
        relocations.put("mp.opentracing.server.operation-name-provider", "quarkus.opentracing.server.operation-name-provider");
        relocations.put("quarkus.opentracing.server.operation-name-provider", "mp.opentracing.server.operation-name-provider");
        return Collections.unmodifiableMap(relocations);
    }
}

